/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.external.ldap;

import com.tandbergtv.neptune.realm.persist.ExternalUser;
import com.tandbergtv.neptune.realm.persist.SearchMetadata;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapConfigurationManager;
import com.tandbergtv.neptune.usermgmt.external.ldap.LdapContextFactory;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.AuthenticationConfiguration;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.ConnectionConfiguration;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.ExternalUserType;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapConfiguration;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapQuery;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapSearchControls;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapSearchDefaults;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.LdapSearchScope;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.Property;
import com.tandbergtv.neptune.usermgmt.external.ldap.conf.ProviderConfiguration;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;
import javax.naming.ldap.SortControl;
import javax.naming.ldap.SortKey;
import org.apache.log4j.Logger;

public class LdapContextManager {
    private static final Logger logger = Logger.getLogger(LdapContextManager.class);
    private final LdapConfigurationManager configurationManager;
    private final LdapContextFactory contextFactory;

    public LdapContextManager(LdapConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
        ConnectionConfiguration connection = this.getConfiguration().getConnection();
        Map<String, String> environment = this.buildEnvironment(connection);
        this.contextFactory = new LdapContextFactory(environment, null);
    }

    public LdapContext openContext() throws NamingException {
        return this.contextFactory.newLdapContext();
    }

    public LdapContext openContext(String userDN, String password) throws NamingException {
        if (userDN == null || userDN.isEmpty()) {
            throw new IllegalArgumentException("The userDN cannot be a blank string");
        }
        AuthenticationConfiguration authConfig = this.getConfiguration().getAuthenication();
        ConnectionConfiguration connection = authConfig != null ? authConfig.getConnectionOverrides() : null;
        Map<String, String> environmentOverrides = this.buildEnvironment(connection);
        environmentOverrides.put("java.naming.security.principal", userDN);
        environmentOverrides.put("java.naming.security.credentials", password);
        return this.contextFactory.newLdapContext(environmentOverrides);
    }

    public void closeContext(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (NamingException e) {
                logger.warn((Object)("Error closing the LdapContext: " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
    }

    public ExternalUser get(LdapContext context, String userDN) throws NamingException {
        try {
            Attributes attributes = context.getAttributes(userDN, this.getReturningAttributes());
            return this.getExternalUser(userDN, attributes);
        }
        catch (NameNotFoundException e) {
            return null;
        }
    }

    public String getBaseDN(LdapQuery query) {
        String baseDN = query.getBaseDN();
        if (baseDN == null || baseDN.trim().isEmpty()) {
            baseDN = this.getSearchDefaults().getBaseDN();
        }
        return baseDN != null ? baseDN.trim() : "";
    }

    public SearchControls buildSearchControls(LdapQuery query) {
        SearchControls controls = new SearchControls();
        LdapSearchControls configuredControls = query.getSearchControls();
        controls.setSearchScope(this.getSearchScope(configuredControls));
        controls.setCountLimit(this.getCountLimit(configuredControls));
        controls.setTimeLimit(this.getTimeLimit(configuredControls));
        controls.setReturningAttributes(this.getReturningAttributes());
        controls.setReturningObjFlag(this.isReturningObjFlag(configuredControls));
        controls.setDerefLinkFlag(this.isDerefLinkFlag(configuredControls));
        return controls;
    }

    public List<ExternalUser> search(LdapContext context, String baseDN, String filterExpression, String[] filterArguments, SearchControls controls) throws NamingException {
        NamingEnumeration<SearchResult> results = context.search(baseDN, filterExpression, (Object[])filterArguments, controls);
        ArrayList<ExternalUser> users = new ArrayList<ExternalUser>();
        int recordIndex = -1;
        while (!this.isCountLimitReached(recordIndex, controls) && results.hasMore()) {
            ++recordIndex;
            SearchResult result = results.next();
            users.add(this.getExternalUser(result));
        }
        return users;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public com.tandbergtv.neptune.realm.persist.SearchResult<ExternalUser> search(LdapContext context, String baseDN, String filterExpression, String[] filterArguments, SearchControls searchControls, SearchMetadata metadata) throws NamingException, IOException {
        Control[] oldRequestControls = context.getRequestControls();
        try {
            com.tandbergtv.neptune.realm.persist.SearchResult<ExternalUser> searchResult = this.pageSearch(context, baseDN, filterExpression, filterArguments, searchControls, metadata);
            return searchResult;
        }
        finally {
            context.setRequestControls(oldRequestControls);
        }
    }

    private LdapConfiguration getConfiguration() {
        return this.configurationManager.getConfiguration();
    }

    private ProviderConfiguration getProviderConfiguration() {
        return this.getConfiguration().getProvider();
    }

    private LdapSearchDefaults getSearchDefaults() {
        return this.getConfiguration().getSearchDefaults();
    }

    private Map<String, String> buildEnvironment(ConnectionConfiguration connection) {
        List<Property> connectionProperties;
        HashMap<String, String> environment = new HashMap<String, String>();
        if (connection != null && (connectionProperties = connection.getProperty()) != null) {
            for (Property connectionProperty : connectionProperties) {
                String name = connectionProperty.getName();
                String value = connectionProperty.getValue();
                environment.put(name, value);
            }
        }
        return environment;
    }

    private int getSearchScope(LdapSearchControls controls) {
        LdapSearchScope searchScope;
        LdapSearchScope ldapSearchScope = searchScope = controls != null ? controls.getSearchScope() : null;
        if (searchScope == null) {
            searchScope = this.getSearchDefaults().getSearchScope();
        }
        int scope = 0;
        switch (searchScope) {
            case OBJECT: {
                scope = 0;
                break;
            }
            case ONE_LEVEL: {
                scope = 1;
                break;
            }
            case SUBTREE: {
                scope = 2;
            }
        }
        return scope;
    }

    private long getCountLimit(LdapSearchControls controls) {
        Long countLimit;
        Long l = countLimit = controls != null ? controls.getCountLimit() : null;
        if (countLimit == null) {
            countLimit = this.getSearchDefaults().getCountLimit();
        }
        return countLimit < 0L ? 0L : countLimit;
    }

    private int getTimeLimit(LdapSearchControls controls) {
        Integer timeLimit;
        Integer n = timeLimit = controls != null ? controls.getTimeLimit() : null;
        if (timeLimit == null) {
            timeLimit = this.getSearchDefaults().getTimeLimit();
        }
        if (timeLimit < 0) {
            timeLimit = 0;
        }
        return timeLimit * 1000;
    }

    private String[] getReturningAttributes() {
        ArrayList<String> attributes = new ArrayList<String>();
        ExternalUserType type = this.getConfiguration().getProvider().getExternalUser();
        this.addAttributeName(type.getUserName(), attributes);
        this.addAttributeName(type.getFirstName(), attributes);
        this.addAttributeName(type.getLastName(), attributes);
        this.addAttributeName(type.getEmail(), attributes);
        this.addAttributeName(type.getPhone(), attributes);
        this.addAttributeName(type.getExtension(), attributes);
        this.addAttributeName(type.getEmployeeId(), attributes);
        this.addAttributeName(type.getDepartment(), attributes);
        this.addAttributeName(type.getLocation(), attributes);
        return attributes.toArray(new String[attributes.size()]);
    }

    private void addAttributeName(String attributeName, List<String> attributes) {
        if (attributeName == null) {
            return;
        }
        if (!(attributeName = attributeName.trim()).isEmpty()) {
            attributes.add(attributeName);
        }
    }

    private boolean isReturningObjFlag(LdapSearchControls controls) {
        Boolean flag;
        Boolean bl = flag = controls != null ? controls.isReturningObjFlag() : null;
        if (flag == null) {
            flag = this.getSearchDefaults().isReturningObjFlag();
        }
        return flag;
    }

    private boolean isDerefLinkFlag(LdapSearchControls controls) {
        Boolean flag;
        Boolean bl = flag = controls != null ? controls.isDerefLinkFlag() : null;
        if (flag == null) {
            flag = this.getSearchDefaults().isDerefLinkFlag();
        }
        return flag;
    }

    private com.tandbergtv.neptune.realm.persist.SearchResult<ExternalUser> pageSearch(LdapContext context, String baseDN, String filterExpression, String[] filterArguments, SearchControls searchControls, SearchMetadata metadata) throws NamingException, IOException {
        int pageSize = this.getPageSize(metadata, searchControls);
        PagedResultsControl pagedResultsControl = this.getPagedResultsControl(pageSize, null);
        SortControl sortControl = this.getSortControl(metadata);
        ArrayList<ExternalUser> users = new ArrayList<ExternalUser>();
        int count = 0;
        int pageNumber = -1;
        byte[] pageCookie = null;
        do {
            ArrayList<BasicControl> controlList = new ArrayList<BasicControl>(2);
            if (pagedResultsControl != null) {
                controlList.add(pagedResultsControl);
            }
            if (sortControl != null) {
                controlList.add(sortControl);
            }
            Control[] requestControls = controlList.toArray(new Control[controlList.size()]);
            context.setRequestControls(requestControls);
            NamingEnumeration<SearchResult> enumeration = context.search(baseDN, filterExpression, (Object[])filterArguments, searchControls);
            if (pagedResultsControl != null) {
                PagedResultsResponseControl response = this.getPagedResultsResponseControl(context);
                count = response.getResultSize();
                pageCookie = response.getCookie();
                pagedResultsControl = this.getPagedResultsControl(pageSize, pageCookie);
                if (this.isPageWithRecords(++pageNumber, pageSize, metadata)) {
                    this.getFromPagedRecords(pageNumber, pageSize, enumeration, metadata, users);
                }
                if (!this.isLastPageWithRecords(pageNumber, pageSize, metadata)) continue;
                break;
            }
            return this.getFromAllRecords(enumeration, metadata, searchControls);
        } while (pageCookie != null);
        if (users.size() > 0 && count == 0) {
            count = -1;
        }
        return new com.tandbergtv.neptune.realm.persist.SearchResult(users, count);
    }

    private int getPageSize(SearchMetadata metadata, SearchControls searchControls) {
        int pageSize = metadata.getMaximumRecordCount();
        long countLimit = searchControls.getCountLimit();
        if (countLimit > 0L && countLimit < (long)pageSize) {
            pageSize = (int)countLimit;
        }
        return pageSize;
    }

    private PagedResultsControl getPagedResultsControl(int pageSize, byte[] cookie) throws IOException {
        if (!this.getProviderConfiguration().getSearchQueries().isPagingSupported()) {
            return null;
        }
        return new PagedResultsControl(pageSize, cookie, true);
    }

    private SortControl getSortControl(SearchMetadata metadata) throws IOException {
        String defaultSortFieldName;
        String fieldName = metadata.getSortField();
        if (fieldName != null) {
            fieldName = fieldName.trim();
        }
        ArrayList<SortKey> sortKeyList = new ArrayList<SortKey>(2);
        SortKey sortKey = this.getSortKey(fieldName, metadata.getSortOrder());
        if (sortKey != null) {
            sortKeyList.add(sortKey);
        }
        if (!(defaultSortFieldName = ExternalUser.USERNAME_FIELD_NAME).equals(fieldName) && (sortKey = this.getSortKey(fieldName, SearchMetadata.SortOrder.Ascending)) != null) {
            sortKeyList.add(sortKey);
        }
        if (sortKeyList.size() == 0) {
            return null;
        }
        SortKey[] sortKeys = sortKeyList.toArray(new SortKey[sortKeyList.size()]);
        return new SortControl(sortKeys, true);
    }

    private SortKey getSortKey(String fieldName, SearchMetadata.SortOrder sortOrder) {
        String attributeName;
        List<String> names = this.getProviderConfiguration().getSortFieldName();
        if (names.contains(fieldName) && (attributeName = this.getAttributeName(fieldName)) != null) {
            boolean ascendingOrder = SearchMetadata.SortOrder.Ascending.equals((Object)sortOrder);
            return new SortKey(attributeName, ascendingOrder, null);
        }
        return null;
    }

    private String getAttributeName(String fieldName) {
        if (fieldName == null) {
            return null;
        }
        String attributeName = null;
        if (fieldName.equals(ExternalUser.DEPARTMENT_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getDepartment();
        } else if (fieldName.equals(ExternalUser.EMAIL_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getEmail();
        } else if (fieldName.equals(ExternalUser.EMPLOYEEID_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getEmployeeId();
        } else if (fieldName.equals(ExternalUser.EXTENSION_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getExtension();
        } else if (fieldName.equals(ExternalUser.FIRSTNAME_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getFirstName();
        } else if (fieldName.equals(ExternalUser.LASTNAME_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getLastName();
        } else if (fieldName.equals(ExternalUser.LOCATION_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getLocation();
        } else if (fieldName.equals(ExternalUser.PHONE_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getPhone();
        } else if (fieldName.equals(ExternalUser.USERNAME_FIELD_NAME)) {
            attributeName = this.getProviderConfiguration().getExternalUser().getUserName();
        }
        if (attributeName != null) {
            attributeName = attributeName.trim();
        }
        return attributeName != null && !attributeName.isEmpty() ? attributeName : null;
    }

    private PagedResultsResponseControl getPagedResultsResponseControl(LdapContext context) throws NamingException {
        Control[] responseControls = context.getResponseControls();
        if (responseControls != null) {
            for (Control control : responseControls) {
                if (!(control instanceof PagedResultsResponseControl)) continue;
                return (PagedResultsResponseControl)control;
            }
        }
        throw new RuntimeException("Did not find expected PagedResultsResponseControl");
    }

    private boolean isPageWithRecords(int pageNumber, int pageSize, SearchMetadata metadata) {
        int pageStartIndex = this.getFirstIndexOnPage(pageNumber, pageSize);
        int pageEndIndex = this.getLastIndexOnPage(pageNumber, pageSize);
        int firstIndex = this.getFirstRecordIndex(metadata);
        int lastIndex = this.getLastRecordIndex(metadata);
        return pageEndIndex >= firstIndex && pageStartIndex <= lastIndex;
    }

    private boolean isLastPageWithRecords(int pageNumber, int pageSize, SearchMetadata metadata) {
        int lastIndex;
        int pageEndIndex = this.getLastIndexOnPage(pageNumber, pageSize);
        return pageEndIndex >= (lastIndex = this.getLastRecordIndex(metadata));
    }

    private void getFromPagedRecords(int pageNumber, int pageSize, NamingEnumeration<SearchResult> enumeration, SearchMetadata metadata, List<ExternalUser> users) throws NamingException {
        int firstIndex = this.getFirstRecordIndex(metadata);
        int lastIndex = this.getLastRecordIndex(metadata);
        int currentIndex = this.getFirstIndexOnPage(pageNumber, pageSize) - 1;
        while (enumeration.hasMore()) {
            SearchResult result = enumeration.next();
            if (++currentIndex >= firstIndex && currentIndex <= lastIndex) {
                users.add(this.getExternalUser(result));
                continue;
            }
            if (currentIndex <= lastIndex) continue;
            break;
        }
    }

    private com.tandbergtv.neptune.realm.persist.SearchResult<ExternalUser> getFromAllRecords(NamingEnumeration<SearchResult> enumeration, SearchMetadata metadata, SearchControls controls) throws NamingException {
        ArrayList<ExternalUser> users = new ArrayList<ExternalUser>();
        int firstIndex = this.getFirstRecordIndex(metadata);
        int lastIndex = this.getLastRecordIndex(metadata);
        int currentIndex = -1;
        while (!this.isCountLimitReached(currentIndex, controls) && enumeration.hasMore()) {
            SearchResult result = enumeration.next();
            if (++currentIndex < firstIndex || currentIndex > lastIndex) continue;
            users.add(this.getExternalUser(result));
        }
        int size = currentIndex + 1;
        return new com.tandbergtv.neptune.realm.persist.SearchResult(users, size);
    }

    private boolean isCountLimitReached(int currentRecordIndex, SearchControls controls) {
        long countLimit = controls.getCountLimit();
        return countLimit > 0L && countLimit <= (long)(currentRecordIndex + 1);
    }

    private int getFirstRecordIndex(SearchMetadata metadata) {
        return metadata.getStartRecord();
    }

    private int getLastRecordIndex(SearchMetadata metadata) {
        return metadata.getStartRecord() + metadata.getMaximumRecordCount() - 1;
    }

    private int getFirstIndexOnPage(int pageNumber, int pageSize) {
        return pageNumber * pageSize;
    }

    private int getLastIndexOnPage(int pageNumber, int pageSize) {
        return (pageNumber + 1) * pageSize - 1;
    }

    private ExternalUser getExternalUser(SearchResult result) throws NamingException {
        if (result == null) {
            return null;
        }
        String externalKey = result.getNameInNamespace();
        return this.getExternalUser(externalKey, result.getAttributes());
    }

    private ExternalUser getExternalUser(String key, Attributes attributes) throws NamingException {
        ExternalUser user = new ExternalUser(key);
        ExternalUserType type = this.getConfiguration().getProvider().getExternalUser();
        user.setUserName(this.getAttributeValue(attributes, type.getUserName()));
        user.setFirstName(this.getAttributeValue(attributes, type.getFirstName()));
        user.setLastName(this.getAttributeValue(attributes, type.getLastName()));
        user.setEmail(this.getAttributeValue(attributes, type.getEmail()));
        user.setPhone(this.getAttributeValue(attributes, type.getPhone()));
        user.setExtension(this.getAttributeValue(attributes, type.getExtension()));
        user.setEmployeeId(this.getAttributeValue(attributes, type.getEmployeeId()));
        user.setDepartment(this.getAttributeValue(attributes, type.getDepartment()));
        user.setLocation(this.getAttributeValue(attributes, type.getLocation()));
        return user;
    }

    private String getAttributeValue(Attributes attributes, String attributeName) throws NamingException {
        if (attributeName == null || attributes == null) {
            return null;
        }
        attributeName = attributeName.trim();
        Attribute attribute = attributes.get(attributeName);
        String value = null;
        if (attribute != null) {
            int size = attribute.size();
            boolean ordered = attribute.isOrdered();
            if (size == 1 || size > 1 && ordered) {
                Object attributeValue = attribute.get();
                if (attributeValue != null) {
                    value = attributeValue.toString();
                }
            } else if (size > 1 && !ordered) {
                ArrayList<String> values = new ArrayList<String>();
                NamingEnumeration<?> attributeValues = attribute.getAll();
                while (attributeValues.hasMore()) {
                    Object attributeValue = attributeValues.next();
                    if (attributeValue == null) continue;
                    values.add(attributeValue.toString());
                }
                if (!values.isEmpty()) {
                    Collections.sort(values, Collator.getInstance());
                    value = (String)values.get(0);
                }
            }
        }
        return value;
    }
}

