/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.persist;

import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.UserKey;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Formula;

@Entity
@Table(name="CMS_USER", uniqueConstraints={@UniqueConstraint(columnNames={"USERNAME"})})
@NamedQueries(value={@NamedQuery(name="User.FindByUserName", query="SELECT user FROM User user WHERE user.userName = :userName"), @NamedQuery(name="User.FindAll", query="SELECT user FROM User user ORDER BY user.userName"), @NamedQuery(name="User.GetPassword", query="SELECT user.password FROM User user WHERE user.id = :userId"), @NamedQuery(name="User.FindByExternalKey", query="SELECT user FROM User user WHERE user.externalKey = :externalKey and user.externalKey is not null")})
public class User
implements Serializable,
Comparable<User> {
    private static final long serialVersionUID = -4271492741128343502L;
    private Long id;
    private String externalKey;
    private boolean externallyAuthenticated = false;
    private Date syncDate = null;
    private String userName;
    private String password;
    private Date passwordModifiedDate;
    private boolean active = true;
    private String firstName;
    private String lastName;
    private String email;
    private String phone;
    private String extension;
    private String employeeId;
    private String department;
    private String location;
    private Set<Role> roles = new HashSet<Role>();
    public static String ID_FIELD_NAME = "id";
    public static String EXTERNAL_KEY_FIELD_NAME = "externalKey";
    public static String USERNAME_FIELD_NAME = "userName";
    public static String FIRSTNAME_FIELD_NAME = "firstName";
    public static String LASTNAME_FIELD_NAME = "lastName";
    public static String EMAIL_FIELD_NAME = "email";
    public static String PHONE_FIELD_NAME = "phone";
    public static String EXTENSION_FIELD_NAME = "extension";
    public static String EMPLOYEEID_FIELD_NAME = "employeeId";
    public static String DEPARTMENT_FIELD_NAME = "department";
    public static String LOCATION_FIELD_NAME = "location";

    @Id
    @Column(name="USERID")
    @SequenceGenerator(name="UserID Sequence Generator", sequenceName="CMS_USER_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="UserID Sequence Generator")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="EXTERNALKEY", unique=true, updatable=false)
    public String getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(String externalKey) {
        this.externalKey = externalKey;
    }

    @Transient
    public UserKey getUserKey() {
        return new UserKey(this.getId());
    }

    public void setUserKey(UserKey userKey) {
        this.setId(userKey != null ? userKey.getId() : null);
    }

    @Column(name="USERNAME", unique=true, nullable=false, updatable=false)
    @Basic(optional=false)
    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Column(name="PASSWORD")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Column(name="PASSWORDMODIFIEDDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getPasswordModifiedDate() {
        return this.passwordModifiedDate;
    }

    public void setPasswordModifiedDate(Date passwordModifiedDate) {
        this.passwordModifiedDate = passwordModifiedDate;
    }

    @Column(name="ACTIVE", nullable=false)
    @Basic(optional=false)
    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Column(name="FIRSTNAME")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    @Column(name="LASTNAME")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @Column(name="EMAIL")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @Column(name="PHONE")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @Column(name="EXTENSION")
    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    @Column(name="EMPLOYEEID")
    public String getEmployeeId() {
        return this.employeeId;
    }

    public void setEmployeeId(String employeeId) {
        this.employeeId = employeeId;
    }

    @Column(name="DEPARTMENT")
    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    @Column(name="LOCATION")
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    @ManyToMany
    @JoinTable(name="CMS_USERROLES", joinColumns={@JoinColumn(name="USERID", nullable=false)}, inverseJoinColumns={@JoinColumn(name="ROLEID", nullable=false)})
    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        if (roles == null) {
            roles = new HashSet<Role>();
        }
        this.roles = roles;
    }

    @Formula(value="(SELECT COUNT(u.USERID) FROM CMS_USER u WHERE u.USERID = USERID AND ((u.EXTERNALKEY IS NULL AND u.PASSWORD IS NULL) OR u.EXTERNALKEY IS NOT NULL))")
    public boolean isExternallyAuthenticated() {
        return this.externallyAuthenticated;
    }

    public void setExternallyAuthenticated(boolean externallyAuthenticated) {
        this.externallyAuthenticated = externallyAuthenticated;
    }

    @Column(name="SYNCDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getSyncDate() {
        return this.syncDate;
    }

    public void setSyncDate(Date syncDate) {
        this.syncDate = syncDate;
    }

    public String toString() {
        return this.getUserKey().toString() + " '" + this.userName + "'";
    }

    public int hashCode() {
        UserKey key = this.getUserKey();
        return key.isAssigned() ? key.hashCode() * 5 - 67 : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return this.getId() != null && this.getId().equals(other.getId());
    }

    @Override
    public int compareTo(User u) {
        if (this.userName != null) {
            if (u.userName != null) {
                return this.userName.compareTo(u.userName);
            }
            return -1;
        }
        return 0;
    }
}

