package com.tandbergtv.neptune.ui.framework.client.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class NeptuneSecurityImpl implements NeptuneSecurity {
	private final String username;
	private final Set<String> roles;

	public NeptuneSecurityImpl(String username, List<String> roles) {
		this.username = username;
		this.roles = new HashSet<String>();
		for (String role : roles)
			this.roles.add(role);
	}

	public String getUsername() {
		return username;
	}

	public boolean isUserInRole(String role) {
		return roles.contains(role);
	}

	public Collection<String> getRoles() {
		return roles;
	}

}
