package com.tandbergtv.neptune.ui.realm.server;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.BeanUtils;

import com.tandbergtv.cms.portal.util.paging.PageSource;
import com.tandbergtv.cms.portal.util.transaction.Transactional;
import com.tandbergtv.neptune.authorization.service.IModuleManager;
import com.tandbergtv.neptune.realm.persist.Module;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleUiService;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiModule;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiPermission;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRole;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleKey;
import com.tandbergtv.neptune.ui.realm.client.tab.role.UiRoleList;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.validation.ValidationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

public class RoleUiServiceImpl implements RoleUiService, NeptuneRemoteService {
	private static final long serialVersionUID = 1L;

	private IRoleManager inner = InjectionUtil.injectInstance(
			"cms/RoleManager/local", IRoleManager.class);

	private IModuleManager moduleService = InjectionUtil.injectInstance(
			"cms/ModuleManager/local", IModuleManager.class);

	@Override
	public Class<?> getServiceImplementation() {
		return getClass();
	}

	@Override
	public String getRelativePath() {
		return "service/realm/roleService";
	}

	@Override
	@Transactional
	public void deleteRoles(List<UiRoleKey> ids) {
		for (UiRoleKey id : ids)
			inner.deleteRole(new RoleKey(id.getId(), id.getExternalKey()));
	}

	@Override
	@PageSource
	@Transactional
	public UiRoleList listRoles(int start, int length, String sortBy,
			boolean isAscending) {
		final List<UiRole> uRoles = new ArrayList<UiRole>();
		final List<Role> bRoles = inner.getRoles();
		for (Role bRole : bRoles) {
			UiRole uRole = new UiRole();
			copyProperties(bRole, uRole);
			uRoles.add(uRole);
		}
		UiRoleList roleList = new UiRoleList(uRoles, uRoles.size());
		return roleList;
	}

	private void copyProperties(Module bModule, UiModule uModule) {
		BeanUtils.copyProperties(bModule, uModule);

		List<UiPermission> uPermissions = new ArrayList<UiPermission>();
		for (Permission bPermission : bModule.getPermissions()) {
			UiPermission uPermission = new UiPermission();
			BeanUtils.copyProperties(bPermission, uPermission);
			uPermissions.add(uPermission);
		}
		uModule.setPermissions(uPermissions);
	}

	private void copyProperties(Role bRole, UiRole uRole) {
		// copy basic properties
		BeanUtils.copyProperties(bRole, uRole);

		// copy permission ids
		Collection<Long> permissionIds = new ArrayList<Long>(bRole
				.getPermissions().size());
		for (Permission bPermission : bRole.getPermissions()) {
			permissionIds.add(bPermission.getId());
		}
		uRole.setPermissionIds(permissionIds);
	}

	private void copyProperties(UiRole uRole, Role bRole) {
		// copy basic properties
		BeanUtils.copyProperties(uRole, bRole);

		// copy permissions
		Set<Permission> bPermissions = new HashSet<Permission>();
		for (Long permissionId : uRole.getPermissionIds()) {
			// only need to copy ids, since we do not change any other data
			Permission bPermission = new Permission();
			bPermission.setId(permissionId);
			bPermissions.add(bPermission);
		}
		bRole.setPermissions(bPermissions);
	}

	@Override
	@Transactional
	public UiRole getRole(UiRoleKey key) {
		UiRole uRole = new UiRole();
		Role bRole = inner.getRole(new RoleKey(key.getId(), key
				.getExternalKey()));
		copyProperties(bRole, uRole);
		return uRole;
	}

	@Override
	@Transactional
	public List<UiModule> getModules() {
		final List<UiModule> uModules = new ArrayList<UiModule>();
		final List<Module> bModules = moduleService.getModules();
		for (Module bModule : bModules) {
			UiModule uModule = new UiModule();
			copyProperties(bModule, uModule);
			uModules.add(uModule);
		}
		return uModules;
	}

	@Override
	public UiRoleKey save(UiRole uRole) throws com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException {
		Role bRole = new Role();
		copyProperties(uRole, bRole);
		try {
			if (!bRole.getRoleKey().isAssigned())
				bRole = inner.createRole(bRole);
			else
				inner.updateRole(bRole);
		} catch(ValidationException ve) {
			throw new com.tandbergtv.neptune.widgettoolkit.client.application.ValidationException(
					ve.getValidationMessages());
		}
		return new UiRoleKey(bRole.getId(), bRole.getExternalKey());
	}

	
}
