package com.tandbergtv.neptune.ui.framework.server;

import java.util.ArrayList;
import java.util.List;

import javax.servlet.http.HttpSession;

import org.jboss.web.tomcat.security.login.WebAuthentication;

import com.tandbergtv.neptune.authorization.service.IAuthorizationService;
import com.tandbergtv.neptune.ui.framework.client.Credentials;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.util.InjectionUtil;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

public class LoginUiServiceImpl implements LoginUiService,
		NeptuneRemoteService, Constants {
	private static final long serialVersionUID = 1L;
 
	private IAuthorizationService authorizationService = InjectionUtil
			.injectInstance("cms/AuthorizationService/local",
					IAuthorizationService.class);

	private HttpSession httpSession;

	public void setHttpSession(HttpSession httpSession) {
		this.httpSession = httpSession;
	}

	@Override
	public String getRelativePath() {
		return "service/loginService";
	}

	@Override
	public Class<?> getServiceImplementation() {
		return getClass();
	}

	private List<String> getRoles() throws NeptuneException {
		if (getWebAuthentication() == null)
			throw new AuthenticationException();
		List<String> roles = new ArrayList<String>();
		roles.addAll(authorizationService.getAuthorizedRoles());
		return roles;
	}

	private WebAuthentication getWebAuthentication() {
		return (WebAuthentication) httpSession
				.getAttribute(Constants.WEB_AUTHENTICATION);
	}

	private void setWebAuthentication(WebAuthentication webAuthentication) {
		httpSession.setAttribute(Constants.WEB_AUTHENTICATION,
				webAuthentication);
	}

	public List<String> login(String username, String password)
			throws NeptuneException {
		logout();
		WebAuthentication webAuthentication = new WebAuthentication();
		if (!webAuthentication.login(username, password))
			throw new AuthenticationException();
		setWebAuthentication(webAuthentication);

		return getRoles();
	}

	public void logout() {
		// on logout just invalidate the session so that WebAuthentication
		// performs the actual logout from the system, this is the best approach
		// since the same exact code path will be taken on session timeout
		if (getWebAuthentication() != null) {
			//			
			// removeWebAuthentication().logout();
			httpSession.invalidate();
		}
	}

	@Override
	public Credentials getCredentials() throws NeptuneException {
		if (getWebAuthentication() == null)
			throw new AuthenticationException();
		List<String> roles = new ArrayList<String>();
		roles.addAll(authorizationService.getAuthorizedRoles());
		String username = authorizationService.getUserName();
		return new Credentials(username, roles);
	}
}
