package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.KeySerializer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.BookmarkFeatureImpl;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.TableInternal;

public class UserBookmarkFeatureImpl extends BookmarkFeatureImpl<UiUserKey, UserRecord> {
	private TableInternal<UiUserKey, UserRecord> tableInternal;
	private static final String USER_NAME_ANCHOR = "Edit?userName=";
	private final UserUiServiceAsync userService = GWT.create(UserUiService.class);
	private RealmConstants constants = GWT.create(RealmConstants.class);
	
	public UserBookmarkFeatureImpl(
			TableInternal<UiUserKey, UserRecord> tableInternal,
			KeySerializer<UiUserKey> keySerializer) {
		super(tableInternal, keySerializer);
		this.tableInternal = tableInternal;
	}

	@Override
	public void anchorChanged(String anchor) {
		/* Check for anchor with user name */
		if (anchor != null && anchor.startsWith(USER_NAME_ANCHOR)) {
			final String userName = anchor.substring(USER_NAME_ANCHOR.length());
			userService.getUser(userName, new NeptuneAsyncCallback<UiUser>() {
						public void onNeptuneFailure(Throwable caught) {
							if(caught instanceof UserNotFoundException)
								Window.alert(constants.userNotFoundForUserName() + userName);
							else
								Window.alert(caught.getLocalizedMessage());
						}

						public void onNeptuneSuccess(UiUser result) {
							tableInternal.showRecord(new UserRecord(result));
						}
					});
		} else {
			super.anchorChanged(anchor);
		}
	}
}