package com.tandbergtv.neptune.ui.realm.client.tab.user;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.ui.realm.client.event.UserAddedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.UserDeletedEvent;
import com.tandbergtv.neptune.ui.realm.client.event.UserUpdatedEvent;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.event.NeptuneEvent;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.DetailView;

public final class UserDetailFeature implements DetailFeature<UiUserKey, UserRecord> {

	private final UserUiServiceAsync userService = GWT.create(UserUiService.class);

	private Listener<UiUserKey, UserRecord> listener;
	private UserDataProvider dataProvider;
	private EventSink eventSink;
	private NeptuneSecurity security;
	
	public UserDetailFeature(UserDataProvider dataProvider, EventSink eventSink, NeptuneSecurity security) {
		this.dataProvider = dataProvider;
		this.eventSink = eventSink;
		this.security = security;
	}
	
	public void getNew(AsyncCallback<UserRecord> callback) {
		UserRecord record = new UserRecord(new UiUser());
		callback.onSuccess(record);
	}

	public DetailView<UiUserKey, UserRecord> getView(final UserRecord record,
			final DetailViewCallback<UiUserKey, UserRecord> callback) {
		final UserRecordDetailView userRecordDetailView =
			new UserRecordDetailView(record, dataProvider, callback);

		if(record.getKey().isValueAssigned()) {
			userRecordDetailView.setSaveAllowed(security.isUserInRole(UserTableProvider.MODIFY_PERMISSION));
			listener.detailViewShownForEdit(userRecordDetailView);
		} else {
			userRecordDetailView.setSaveAllowed(security.isUserInRole(UserTableProvider.CREATE_PERMISSION));
			listener.detailViewShownForCreate(userRecordDetailView);
		}
		
		return userRecordDetailView;
		
	}

	public void save(final UserRecord record, final AsyncCallback<Void> callback) {
		final UiUser user = record.getUser();
		userService.saveUser(user, new NeptuneAsyncCallback<UiUserKey>() {

			public void onNeptuneFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onNeptuneSuccess(UiUserKey userId) {
				NeptuneEvent neptuneEvent = user.getId() == null ? new UserAddedEvent(user) : new UserUpdatedEvent(record
						.getUser());
				user.setKey(userId);
				eventSink.fireEvent(neptuneEvent);
				callback.onSuccess(null);
			}
		});
	}

	public void delete(final List<UserRecord> records, final AsyncCallback<Void> callback) {
		List<UiUserKey> userKeys = new ArrayList<UiUserKey>();
		for (UserRecord record : records)
			userKeys.add(record.getUser().getKey());
		userService.deleteUsers(userKeys, new AsyncCallback<Void>() {
			public void onFailure(Throwable caught) {
				callback.onFailure(caught);
			}

			public void onSuccess(Void result) {
				for (UserRecord record : records)
					eventSink.fireEvent(new UserDeletedEvent(record.getUser()));
				callback.onSuccess(null);
			}
		});
	}

	public boolean hasDetailLink(Column<?, UserRecord> column) {
		if(security.isUserInRole(UserTableProvider.VIEW_PERMISSION) || security.isUserInRole(UserTableProvider.MODIFY_PERMISSION))
			return column.getName().equals("userName");
		else
			return false;
	}

	@Override
	public boolean showCreateButton() {
		return security.isUserInRole(UserTableProvider.CREATE_PERMISSION);
	}

	@Override
	public boolean showDeleteButton() {
		return security.isUserInRole(UserTableProvider.DELETE_PERMISSION);
	}
	
	public void registerListener(DetailFeature.Listener<UiUserKey, UserRecord> listener) {
		this.listener = listener;
	}
}