package com.tandbergtv.neptune.server.dispatcher;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;

import javax.ejb.EJBAccessException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.apache.log4j.Logger;

import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPC;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.google.gwt.user.server.rpc.SerializationPolicy;
import com.tandbergtv.neptune.ui.framework.client.LoginUiService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.client.security.AuthenticationException;
import com.tandbergtv.neptune.widgettoolkit.client.security.InsufficientRolesException;
import com.tandbergtv.neptune.widgettoolkit.client.security.UserNotLoggedInException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

public class NeptuneRemoteServiceDispatcher extends RemoteServiceServlet {
	private static final int SERVICE_LENGTH = 1;
	Logger LOGGER = Logger.getLogger(NeptuneRemoteServiceDispatcher.class);
	private static final long serialVersionUID = 1L;
	private Map<String, Object> nameToServletClassMap = new HashMap<String, Object>();

	@Override
	public void init() throws ServletException {
		super.init();

		ServiceLoader<NeptuneRemoteService> loader = ServiceLoader
				.load(NeptuneRemoteService.class);
		for (NeptuneRemoteService neptuneRemoteService : loader) {
			try {
				nameToServletClassMap.put(neptuneRemoteService.getRelativePath(),
						neptuneRemoteService.getServiceImplementation()
								.newInstance());
			} catch (Exception e) {
				LOGGER.error("Unable to register neptune servlet: "
						+ neptuneRemoteService.getRelativePath(), e);
			}
		}
	}

	@Override
	public String processCall(String payload) throws SerializationException {
		try {
			HttpServletRequest req = getThreadLocalRequest();
			String path = req.getRequestURI().substring(
					req.getContextPath().length() + SERVICE_LENGTH);
			Object serviceImplementation = nameToServletClassMap.get(path);
			if (serviceImplementation == null)
				throw new IncompatibleRemoteServiceException(
						"Servlet for requested path doesn't exist: " + path);
			else {
				RPCRequest rpcRequest = RPC.decodeRequest(payload,
						serviceImplementation.getClass(), this);
				Method serviceMethod = rpcRequest.getMethod();
				SerializationPolicy serializationPolicy = rpcRequest
						.getSerializationPolicy();
				if (serviceMethod == null) {
					throw new NullPointerException("serviceMethod");
				}

				if (serializationPolicy == null) {
					throw new NullPointerException("serializationPolicy");
				}
				String responsePayload;
				try {
					try {
						//fetch the session
						HttpSession httpSession = getThreadLocalRequest().getSession(true);

						// ensure a user is logged in for all calls except logging in
						if (!(serviceImplementation instanceof LoginUiService) && httpSession.getAttribute("webAuthentication") == null)
							return RPC.encodeResponseForFailure(serviceMethod,
									new UserNotLoggedInException(), serializationPolicy);
						
						// check if setSession is implemented and perform injection if it is
						Method setSessionMethod = serviceImplementation.getClass().getMethod("setHttpSession", HttpSession.class);
						setSessionMethod.invoke(serviceImplementation, httpSession);
					} catch (SecurityException e) {
					} catch (NoSuchMethodException e) {
					}
					Object result = serviceMethod.invoke(serviceImplementation,
							rpcRequest.getParameters());

					responsePayload = RPC.encodeResponseForSuccess(
							serviceMethod, result, serializationPolicy);
				} catch (IllegalAccessException e) {
					SecurityException securityException = new SecurityException(
							formatIllegalAccessErrorMessage(
									serviceImplementation, serviceMethod));
					securityException.initCause(e);
					throw securityException;
				} catch (IllegalArgumentException e) {
					SecurityException securityException = new SecurityException(
							formatIllegalArgumentErrorMessage(
									serviceImplementation, serviceMethod,
									rpcRequest.getParameters()));
					securityException.initCause(e);
					throw securityException;
				} catch (EJBAccessException e) {
					return RPC.encodeResponseForFailure(null,
							new AuthenticationException());
				} catch (InvocationTargetException e) {
					// Try to encode the caught exception
					//
					Throwable cause = e.getCause();
					if (cause instanceof RuntimeException)
					{
						Throwable cause2 = cause.getCause();
						if (cause2 instanceof EJBAccessException)
						{
							return RPC.encodeResponseForFailure(serviceMethod,
									new InsufficientRolesException(), serializationPolicy);
						} else if (cause2 instanceof NeptuneException) {
							return RPC.encodeResponseForFailure(serviceMethod,
									cause2, serializationPolicy);
						}
					}

					responsePayload = RPC.encodeResponseForFailure(
							serviceMethod, cause, serializationPolicy);
				}

				return responsePayload;
			}
		} catch (IncompatibleRemoteServiceException ex) {
			LOGGER
					.error(
							"An IncompatibleRemoteServiceException was thrown while processing this call.",
							ex);
			return RPC.encodeResponseForFailure(null, ex);
		}
	}

	private static String formatIllegalAccessErrorMessage(Object target,
			Method serviceMethod) {
		StringBuffer sb = new StringBuffer();
		sb.append("Blocked attempt to access inaccessible method '");
		sb.append(getSourceRepresentation(serviceMethod));
		sb.append("'");

		if (target != null) {
			sb.append(" on target '");
			sb.append(printTypeName(target.getClass()));
			sb.append("'");
		}

		sb.append("; this is either misconfiguration or a hack attempt");

		return sb.toString();
	}

	private static String formatIllegalArgumentErrorMessage(Object target,
			Method serviceMethod, Object[] args) {
		StringBuffer sb = new StringBuffer();
		sb.append("Blocked attempt to invoke method '");
		sb.append(getSourceRepresentation(serviceMethod));
		sb.append("'");

		if (target != null) {
			sb.append(" on target '");
			sb.append(printTypeName(target.getClass()));
			sb.append("'");
		}

		sb.append(" with invalid arguments");

		if (args != null && args.length > 0) {
			sb.append(Arrays.asList(args));
		}

		return sb.toString();
	}

	private static String getSourceRepresentation(Method method) {
		return method.toString().replace('$', '.');
	}

	private static String printTypeName(Class<?> type) {
		// Primitives
		//
		if (type.equals(Integer.TYPE)) {
			return "int";
		} else if (type.equals(Long.TYPE)) {
			return "long";
		} else if (type.equals(Short.TYPE)) {
			return "short";
		} else if (type.equals(Byte.TYPE)) {
			return "byte";
		} else if (type.equals(Character.TYPE)) {
			return "char";
		} else if (type.equals(Boolean.TYPE)) {
			return "boolean";
		} else if (type.equals(Float.TYPE)) {
			return "float";
		} else if (type.equals(Double.TYPE)) {
			return "double";
		}
		// Arrays
		//
		if (type.isArray()) {
			Class<?> componentType = type.getComponentType();
			return printTypeName(componentType) + "[]";
		}

		// Everything else
		//
		return type.getName().replace('$', '.');
	}
}
