package com.tandbergtv.neptune.ui.framework.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

import com.tandbergtv.neptune.infoprovider.IServerInfoProvider;
import com.tandbergtv.neptune.ui.framework.client.ServerInfo;
import com.tandbergtv.neptune.ui.framework.client.ServerInfoProviderService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;
import com.tandbergtv.neptune.widgettoolkit.server.remote.NeptuneRemoteService;

/**
 * This class looks up all the implementations of the defined interface to get
 * the data that will be passed to all the components.
 * 
 * @author spuranik
 * 
 */
public class ServerInfoProviderServiceImpl implements
		ServerInfoProviderService, NeptuneRemoteService {

	private static final long serialVersionUID = 1L;

	@Override
	public ServerInfo getInfo() throws NeptuneException {
		Map<String, String> infoMap = new HashMap<String, String>();
		List<String> errorMsgs = new ArrayList<String>();

		ServiceLoader<IServerInfoProvider> loader = ServiceLoader
				.load(IServerInfoProvider.class);
		for (IServerInfoProvider provider : loader) {
			try {
				infoMap.putAll(provider.getInfo());
			} catch (Exception e) {
				// If there is an error add it to the list which will also be
				// passed to the component and then keep going with the next
				// provider.
				errorMsgs.add(e.getMessage());
				
				// TODO: logging
			}
		}
		return new ServerInfo(infoMap, errorMsgs);
	}

	@Override
	public String getRelativePath() {
		return "service/serverInfoProviderService";
	}

	@Override
	public Class<?> getServiceImplementation() {
		return getClass();
	}

}
