/*
 * Created on Jan 19, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.ui.framework.client.application;

import com.google.gwt.i18n.client.Messages;

/**
 * Messages for the Header Widget
 * 
 * @author Vijay Silva
 */
public interface HeaderWidgetMessages extends Messages {

	/**
	 * The title label
	 * 
	 * @param title The title
	 */
	@DefaultMessage("{0}")
	String titleLabel(String title);

	/**
	 * The sub-title label
	 * 
	 * @param subtitle the sub-title
	 */
	@DefaultMessage("{0}")
	String subTitleLabel(String subtitle);

	/**
	 * The label indicating the currently logged-in user
	 * 
	 * @param userName The user name
	 */
	String currentUserLabel(String userName);

	/**
	 * The label for the About button
	 */
	String aboutButton();

	/**
	 * The label for the User Guide button
	 */
	String guideButton();

	/**
	 * The label for the Log Out button
	 */
	String logoutButton();
}
