package com.tandbergtv.neptune.ui.home.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.ui.Composite;
import com.gwtext.client.widgets.layout.ColumnLayoutData;
import com.gwtext.client.widgets.portal.Portal;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;

public class HomeTabPanel extends Composite {
	private final SimpleContainer mainContainer;
	private final List<PortletFactory> portletFactories;
	private final List<Portlet> portlets;
	private Portal portal;
	private PortalColumn col1;
	private PortalColumn col2;
	private int i = 0;
	
	private static final String STYLE_NAME = "home-HomeTabPanel";
	private static final String STYLE_PORTAL = "home-HomeTabPanel-portal";
	private static final String STYLE_PORTAL_COLUMN = "home-HomeTabPanel-portalColumn";

	public HomeTabPanel(NeptuneSecurity neptuneSecurity, List<PortletFactory> portletFactories) {
		mainContainer = new SimpleContainer();
		mainContainer.addStyleName(STYLE_NAME);
		this.portletFactories = portletFactories;
		this.portlets = new ArrayList<Portlet>();
		portal = createPortal();
		portal.addClass(STYLE_PORTAL);

		mainContainer.setWidget(portal);
		portal.doLayout();
		
		initWidget(mainContainer);
	}

	private Portal createPortal() {
		Portal portal = new MyPortal();

		portal.setBorder(true);

		ColumnLayoutData layoutData = new ColumnLayoutData(.5);
		col1 = createColumn();
		col2 = createColumn();

		portal.add(col1, layoutData);
		portal.add(col2, layoutData);

		for (PortletFactory portletFactory : portletFactories)
			addPortlet(portletFactory);
				
		return portal;
	}

	private void addPortlet(PortletFactory portletFactory) {
		Portlet portlet = portletFactory.getInstance();
		getColumn(i++).add(portlet);

		/* Cache the portlet, and fire attach event if required */
		portlets.add(portlet);
		if (this.isAttached()) {
			portlet.fireEvent(new DocumentAttachEvent());
		}
	}

	private PortalColumn getColumn(int i) {
		switch (i % 2) {
			case 0:
				return col1;
			case 1:
				return col2;
			default:
				return col1;
		}
	}

	private PortalColumn createColumn() {
		PortalColumn col = new PortalColumn();
		col.addClass(STYLE_PORTAL_COLUMN);
		return col;
	}

	@Override
	protected void onLoad() {
	    super.onLoad();

		for (Portlet portlet : portlets) {
			portlet.fireEvent(new DocumentAttachEvent());
		}
	}

	@Override
	protected void onUnload() {
	    for (Portlet portlet : portlets) {
	    	portlet.fireEvent(new DocumentDetachEvent());
	    }
	    
	    super.onUnload();
	}

	private class MyPortal extends Portal {
		@Override
		protected void onAttach() {
			doLayout();
			super.onAttach();
		}
	}
}
