package com.tandbergtv.neptune.ui.realm.client.tab.user;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.framework.client.i18n.NeptuneConstants;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableDetailViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewChangeHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableViewEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class UserListPanel extends VerticalContainer {
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";
	private static final String CONTAINER_PANEL_STYLE_DETAIL = "headerAndTableDetailPanel";
	
	private NeptuneConstants constants = GWT.create(NeptuneConstants.class);
	private UserTableProvider tableProvider;
	
	public UserListPanel(EventSink eventSink,
			EventListenerRegistry eventListenerRegistry,
			NeptuneSecurity security) {
		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		setSpacing(5);
		
		final HeaderPanel header = new HeaderPanel("");
		/*
		 * hack to not show the header when the table is loading
		 * consequence:
		 *  set the header visible again and again during list-detail view change,
		 *  when it is actually visible 
		 */
		header.setVisible(false);
		add(header);
		
		tableProvider = new UserTableProvider(eventSink, eventListenerRegistry, security);
		tableProvider.getTable().addTableViewChangeHandler(new TableViewChangeHandler<UiUserKey, UserRecord>() {
			@Override
			public void onShowDetailView(TableDetailViewEvent<UiUserKey, UserRecord> event) {
				setStyleName(CONTAINER_PANEL_STYLE_DETAIL);
				if(event.isCreateView()) {
					header.setLabel(constants.createUserHeading());
				} else {
					header.setLabel(constants.viewEditUserHeading()
							+ " " + event.getRecord().getUser().getUserName());
				}
				header.setVisible(true);
			}

			@Override
			public void onShowListView(TableViewEvent event) {
				setStyleName(CONTAINER_PANEL_STYLE_LIST);
				header.setLabel(constants.listUsersHeading());
				header.setVisible(true);
			}});

		add(tableProvider.getTable());
	}

	public UserTableProvider getTableProvider() {
		return tableProvider;
	}

	public void setTableProvider(UserTableProvider tableProvider) {
		this.tableProvider = tableProvider;
	}
	
	public void setAnchorChangeNotifier(AnchorChangeListener anchorChangeListener) {
		tableProvider.setAnchorChangeNotifier(anchorChangeListener);
	}
}
