package com.tandbergtv.neptune.ui.home.client;

import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.portal.PortalColumn;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.CloseListener;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;

/**
 * Represents a Portal Column
 * 
 * @author Daniel Paranhos
 */
public class HomePortalColumn extends PortalColumn implements CloseListener {

    private PortalChangeListener listener;

    public HomePortalColumn( PortalChangeListener listener ) {
        this.listener = listener;
    }

    public HomePortalColumn() {
    }

    @Override
    public void add( Component component ) {
        super.add( component );
        component.setVisible( true );
        notifyPortalChangeListener();
    }

    @Override
    public void insert( int index, Component component ) {
        super.insert( index, component );
        component.setVisible( true );
        notifyPortalChangeListener();
    }

    @Override
    public void remove( Component component, boolean autoDestroy ) {
        super.remove( component, autoDestroy );
        notifyPortalChangeListener();
    }

    private void notifyPortalChangeListener() {
        if ( this.listener != null ) {
            this.listener.notifyPortalChanged();
        }
    }

    @Override
    public void onClose( Portlet portlet ) {
        remove( portlet, false );
        portlet.setVisible( false );
        if ( this.isAttached() ) {
            portlet.fireEvent( new DocumentDetachEvent() );
        }
    }

}