package com.tandbergtv.neptune.ui.realm.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleListPanel;
import com.tandbergtv.neptune.ui.realm.client.tab.user.UserListPanel;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

public class RealmComponent extends ComponentBase {
    
        private final RealmConstants constants = GWT.create( RealmConstants.class );
        
	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		return null;
	}

	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		List<MenuItemBase> adminGroup = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.USER_VIEW)) {
			UserListPanel userListPanel = new UserListPanel(eventSink, eventListenerRegistry);
			final WidgetMenuItem panel = new WidgetMenuItem("User", new SingletonWidgetFactory(
			        userListPanel), userListPanel.getTableProvider().getAnchorChangeListener());
			userListPanel.setAnchorChangeNotifier(panel.getReverseAnchorChangeListener());
			adminGroup.add(panel);
		}

		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.ROLE_VIEW)) {
			RoleListPanel roleListPanel = new RoleListPanel(eventSink, eventListenerRegistry);
			final WidgetMenuItem menuItem = new WidgetMenuItem("Role", new SingletonWidgetFactory(
			        roleListPanel), roleListPanel.getTableProvider().getAnchorChangeListener());
			roleListPanel.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}

		if (adminGroup.size() > 0) {
			tabs.add(new GroupMenuItem("Admin", adminGroup));
		}

		return tabs;
	}

	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		return new ArrayList<E>();
	}

        @Override
        public String getName() {
            return "REALM";
        }
    
        @Override
        public String getDisplayName() {
            return constants.componentDisplayName();
        }
}
