package com.tandbergtv.neptune.ui.realm.client;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.view.ClusterStatusPortlet;
import com.tandbergtv.neptune.ui.realm.client.networkelements.view.HAView;
import com.tandbergtv.neptune.ui.realm.client.tab.role.RoleListPanel;
import com.tandbergtv.neptune.ui.realm.client.tab.user.view.UserView;
import com.tandbergtv.neptune.widgettoolkit.client.application.ClientAuthorizationManager;
import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;
import com.tandbergtv.neptune.widgettoolkit.client.component.ComponentBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.LazyViewWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.Portlet;

public class RealmComponent extends ComponentBase {

	private final RealmConstants constants = GWT.create(RealmConstants.class);

	public List<PortletFactory> listPortlets(final NeptuneSecurity security) {
		List<PortletFactory> portlets = new ArrayList<PortletFactory>();
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.HA_VIEW)) {
			portlets.add(new RealmPortletFactory(new ClusterStatusPortlet()));
		}
		return portlets;
	}

	public List<MenuItemBase> listTabs(final NeptuneSecurity security) {
		List<MenuItemBase> tabs = new ArrayList<MenuItemBase>();
		List<MenuItemBase> adminGroup = new ArrayList<MenuItemBase>();
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.USER_VIEW)) {
			LazyViewWidgetFactory factory = new LazyViewWidgetFactory(new UserView());
			String displayName = constants.userMenuItem();
			final WidgetMenuItem menuItem = new WidgetMenuItem("User", displayName, factory,
			        factory.getAnchorChangeListener());
			factory.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}

		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.ROLE_VIEW)) {
			RoleListPanel roleListPanel = new RoleListPanel();
			String displayName = constants.roleMenuItem();
			WidgetFactory factory = new SingletonWidgetFactory(roleListPanel);
			final WidgetMenuItem menuItem = new WidgetMenuItem("Role", displayName, factory,
			        roleListPanel.getTableProvider().getAnchorChangeListener());
			roleListPanel.setAnchorChangeNotifier(menuItem.getReverseAnchorChangeListener());
			adminGroup.add(menuItem);
		}
		
		if (ClientAuthorizationManager.isAuthorized(RealmComponentPermissions.HA_MODIFY)) {
			HAView haView = new HAView();
			String displayName = constants.haAdminMenuItem();
			WidgetFactory factory = new SingletonWidgetFactory(haView);
			final WidgetMenuItem menuItem = new WidgetMenuItem("HA", displayName, factory,
					haView);
			adminGroup.add(menuItem);
		}

		/* Always return the group even if its empty */
		tabs.add(new GroupMenuItem("Admin", adminGroup));
		return tabs;
	}

	public <E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security) {
		return new ArrayList<E>();
	}

	@Override
	public String getName() {
		return "REALM";
	}

	@Override
	public String getDisplayName() {
		return constants.componentDisplayName();
	}
	
	private final class RealmPortletFactory implements PortletFactory {
		private Portlet portlet;

		public RealmPortletFactory(Portlet portlet) {
			this.portlet = portlet;
		}

		@Override
		public Portlet getInstance() {
			return portlet;
		}

		@Override
		public void release(Portlet widget) {
			this.portlet = null;
		}

		@Override
		public Component getComponent() {
			return RealmComponent.this;
		}
	};
}
