package com.tandbergtv.neptune.ui.realm.client.networkelements.service;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.rpc.RemoteService;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Asynchronous interface for {@link INetworkElementsUIService} RPC service.
 * @author Francisco Bento da Silva Neto
 *
 */
public interface INetworkElementsUIServiceAsync extends RemoteService {

	/**
	 * @see INetworkElementsUIService#getRedundancyStatus()
	 */
	void getRedundancyStatus(AsyncCallback<UiNetworkElementStatus> callback);
	
	/**
	 * 
	 * @see INetworkElementsUIService#getClusterElementsStatus()
	 * @throws NeptuneException
	 */
	void getClusterElementsStatus(AsyncCallback<List<UiNetworkElement>> callback);

	/**
	 * 
	 * @see INetworkElementsUIService#failOverNow()
	 * @throws NeptuneException
	 */
	void failOverNow(AsyncCallback<Boolean> callback);

	/**
	 * 
	 * @see INetworkElementsUIService#switchAutoFailOverPreference()
	 * @throws NeptuneException
	 */
	void switchAutoFailOverPreference(AsyncCallback<Void> callback);
}
