package com.tandbergtv.neptune.ui.realm.client.networkelements.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import com.tandbergtv.neptune.ui.realm.client.RealmUIEvents;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIService;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.UiNetworkElementStatus;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem.AnchorChangeListener;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.BusyIndicator;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.HeaderPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea.MessageArea;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * 		High availability admin page.
 * 
 * @author Francisco Bento da Silva Neto
 *
 */
public class HAView extends VerticalContainer implements AnchorChangeListener, RedundancyStatusUpdateHandler {
	private static final String CONTAINER_PANEL_STYLE_LIST = "headerAndTableListPanel";

	private RealmConstants constants = GWT.create(RealmConstants.class);
	/* The RPC service */
	private final INetworkElementsUIServiceAsync service = GWT.create(INetworkElementsUIService.class);
	
	private RedundancyStatusPanel redundancyStatusPanel;
	private ButtonWidget manualFailOverButton;
	private ButtonWidget failOverNowButton;
	private BusyIndicator busyIndicator;

	private HandlerRegistration clusterStatusEventHandler;

	private MessageArea messageArea;
	
	public HAView() {
		setStyleName(CONTAINER_PANEL_STYLE_LIST);
		setSpacing(5);
		
		final HeaderPanel header = new HeaderPanel(constants.haPageHeading());
		header.setVisible(true);
		add(header);
		
		messageArea = new MessageArea();
		messageArea.setWidth("300px");
		messageArea.setVisible(false);
		add(messageArea);

		redundancyStatusPanel = new RedundancyStatusPanel();
		add(redundancyStatusPanel);
		
		HorizontalContainer horizontalContainer = new HorizontalContainer();
		
		manualFailOverButton = new ButtonWidget();
		manualFailOverButton.addStyleDependentName(StyleNames.COMMIT_BUTTON_STYLE);
		manualFailOverButton.addClickHandler(new ClickHandler() {
			
			@Override
			public void onClick(ClickEvent event) {
				hideMessage();
				showBusyIndicator();
				service.switchAutoFailOverPreference(new NeptuneAsyncCallback<Void>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						hideBusyIndicator();
						showErrorMessage(constants.haError());
					}

					@Override
					public void onNeptuneSuccess(Void result) {
						RedundancyStatusStateHolder.refreshCurrentStatus(true);
						hideBusyIndicator();
					}

				});
			}
		});
		
		horizontalContainer.add(manualFailOverButton);
		
		failOverNowButton = new ButtonWidget(constants.failoverButton());
		failOverNowButton.setStyleDependentName(StyleNames.DATALOSS_BUTTON_STYLE, true);
		failOverNowButton.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hideMessage();
				if (!Window.confirm(constants.failoverConfirmation())) {
					return;
				}
				showBusyIndicator();
				service.failOverNow(new NeptuneAsyncCallback<Boolean>() {
					@Override
					public void onNeptuneFailure(Throwable caught) {
						hideBusyIndicator();
						showErrorMessage(constants.haError());
					}

					@Override
					public void onNeptuneSuccess(Boolean success) {
						hideBusyIndicator();
						if (!success) {
							showErrorMessage(constants.haError());
						} else {
							showInfoMessage(constants.failoverSuccess());
						}
					}

				});
				
			}
		});
		horizontalContainer.add(failOverNowButton);
		add(horizontalContainer);
		
		updateButtons(RedundancyStatusStateHolder.getCurrentStatus());
		busyIndicator = new BusyIndicator(this);
	}
	
	protected void updateButtons(UiNetworkElementStatus status) {
		if (status.isActive() || status.isInactive()) {
			manualFailOverButton.setVisible(true);
			failOverNowButton.setVisible(true);
			if (status.isActive()) {
				// Failover is ON, suggest to turn to OFF
				manualFailOverButton.setText(constants.manualFailOverButtonOFF());
			} else if (status.isInactive()) {
				manualFailOverButton.setText(constants.manualFailOverButtonON());
			} 
		} else {
			manualFailOverButton.setVisible(false);
			failOverNowButton.setVisible(false);
		}
	}
	
	/*
	 * Show the error message in the view
	 */
	private void showErrorMessage(String message) {
		if (message == null)
			message = "";

		messageArea.setErrorMessage(message);
		messageArea.setVisible(true);
	}
	
	/*
	 * Show the info message in the view
	 */
	private void showInfoMessage(String message) {
		if (message == null)
			message = "";

		messageArea.setInfoMessage(message);
		messageArea.setVisible(true);
	}

	/*
	 * Clear the error message displayed in the view
	 */
	private void hideMessage() {
		messageArea.setVisible(false);
		messageArea.setErrorMessage(null);
		messageArea.setInfoMessage(null);
	}
	
	/*
	 * If the widget is attached to the DOM, show the busy indicator
	 */
	private void showBusyIndicator() {
		busyIndicator.center();
	}

	/*
	 * Hide the busy indicator
	 */
	private void hideBusyIndicator() {
		busyIndicator.hide();
	}
	
	@Override
	public void onLoad() {
		if (clusterStatusEventHandler == null) {
			clusterStatusEventHandler = RealmUIEvents.EVENT_BUS.addHandler(RedundancyStatusUpdateEvent.TYPE, this);
		}
		hideMessage();
		// Forces a refresh.
		RedundancyStatusStateHolder.refreshCurrentStatus(true);
	}
	
	@Override
	public void onUnload() {
		if (clusterStatusEventHandler != null) {
			clusterStatusEventHandler.removeHandler();
			clusterStatusEventHandler = null;
		}
		hideMessage();
	}

	@Override
	public void anchorChanged(String anchor) {
	}


	@Override
	public void onRedundancyStatusUpdate(RedundancyStatusUpdateEvent statusUpdatedEvent) {
		updateButtons(statusUpdatedEvent.getRedundancyStatus());
	}
}
