/*

 * Created on Jul 19, 2012
 * 
 * (C) Copyright Ericsson Television Inc.
 */
package com.tandbergtv.neptune.ui.realm.client.networkelements.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.shared.HandlerRegistration;
import com.tandbergtv.neptune.ui.realm.client.RealmUIEvents;
import com.tandbergtv.neptune.ui.realm.client.i18n.RealmConstants;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.UiNetworkElementStatus;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;

/**
 * Displays the current redundancy status. It goes to the server N seconds to get the
 * application server cluster status, and then updates the button color/label.
 * 
 * @author Francisco B. S. Neto
 */
public class RedundancyStatusButton extends ButtonWidget implements RedundancyStatusUpdateHandler {

	/** Styles for the distinct statuses */
	public static final String ACTIVE_STYLE_NAME = "nfw-clusterIndicator-active";
	public static final String INACTIVE_STYLE_NAME = "nfw-clusterIndicator-inactive";
	public static final String FAILED_STYLE_NAME = "nfw-clusterIndicator-fail";

	private final RealmConstants constants = GWT.create(RealmConstants.class);

	private UiNetworkElementStatus redundancyStatus;
	
	private HandlerRegistration handlerRegistration;
	
	/**
	 * Constructor. Use the default pattern for display
	 */
	public RedundancyStatusButton() {
		setVisible(false);
		hookListeners();
	}

	/**
	 * 	Hooks specific listeners used by this widget and its children.
	 * 	Used as a workaround when this widget is attached to a Portlet which doesnt 
	 * propagate calls to onUnload|onDetach events upon close or page change.
	 */
	public void hookListeners() {
		if (handlerRegistration == null) {
			handlerRegistration = RealmUIEvents.EVENT_BUS.addHandler(RedundancyStatusUpdateEvent.TYPE, this);
		}
	}
	
	/**
	 * 	Unhooks any specific listener used by this widget and its children.
	 * 	Used as a workaround when this widget is attached to a Portlet which doesnt 
	 * propagate calls to onUnload|onDetach events upon close or page change. 
	 */
	public void unHookListeners() {
		if (handlerRegistration != null) {
			handlerRegistration.removeHandler();
			handlerRegistration = null;
		}
	}
	// ========================================================================
	// ===================== WIDGET LOAD / UNLOAD AND ACCESS
	// ========================================================================

	/*
	 * Stop the timer (ensuring that no server calls are made)
	 */
	@Override
	protected void onUnload() {
		super.onUnload();
		unHookListeners();
	}
	
	/*
	 * Stop the timer (ensuring that no server calls are made)
	 */
	@Override
	protected void onLoad() {
		super.onLoad();
		refreshState();
	}

	/**
	 * 		Forces this widget to update the current state
	 */
	public void refreshState() {
		hookListeners();
		setRedundancyStatus(RedundancyStatusStateHolder.getCurrentStatus());
	}
	
	@Override
	public void onRedundancyStatusUpdate(RedundancyStatusUpdateEvent statusUpdatedEvent) {
		setRedundancyStatus(statusUpdatedEvent.getRedundancyStatus());
	}

	/*
	 * Set the current time
	 */
	private void setRedundancyStatus(UiNetworkElementStatus redundancyStatus) {
		this.redundancyStatus = redundancyStatus;
		updateWidget();
	}

	public UiNetworkElementStatus getRedundancyStatus() {
		return redundancyStatus;
	}
	
	/*
	 * Update the text in this label to show the current time
	 */
	private void updateWidget() {
		if (redundancyStatus.isDisabled()) {
			setVisible(false);
		} else {
			String text = null;
			String title = null;

			String styleName = null;
			setVisible(true);

			setStyleDependentName(ACTIVE_STYLE_NAME, false);
			setStyleDependentName(INACTIVE_STYLE_NAME, false);
			setStyleDependentName(FAILED_STYLE_NAME, false);
			if (redundancyStatus.isActive()) {
				styleName = ACTIVE_STYLE_NAME;
				text = constants.redundancyStatusActiveLabel();
				title = constants.redundancyStatusActiveDescription();
			} else if (redundancyStatus.isInactive()) {
				styleName = INACTIVE_STYLE_NAME;
				text = constants.redundancyStatusInactiveLabel();
				title = constants.redundancyStatusInactiveDescription();
			} else if (redundancyStatus.isFailed()) {
				styleName = FAILED_STYLE_NAME;
				text = constants.redundancyStatusFailedLabel();
				title = constants.redundancyStatusFailedDescription();
			} 
			setStyleDependentName(styleName, true);
			setText(text);
			setTitle(title);
		}

	}
	
}
