package com.tandbergtv.neptune.ui.realm.client.networkelements.service;

import java.util.List;

import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.RemoteServiceRelativePath;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Service that provides access to the network elements. 
 * 
 * @author Francisco B. S. Neto
 */
@RemoteServiceRelativePath("service/realm/INetworkElementsUIService")
public interface INetworkElementsUIService extends RemoteService {

	/**
	 * Get the current cluster's redundancy Status
	 * 
	 * @return The redundancy status
	 */
	UiNetworkElementStatus getRedundancyStatus() throws NeptuneException;

	/**
	 * Get the cluster elements status.
	 * 
	 * @return
	 * @throws NeptuneException
	 */
	List<UiNetworkElement> getClusterElementsStatus() throws NeptuneException;
	
	/**
	 * Failover the system to a redundant node.
	 * 
	 * @return TRUE if Failover has successfully succeed. FALSE otherwise.
	 */
	Boolean failOverNow();

	/**
	 * Switch the automatic failover preference.
	 * 
	 */
	void switchAutoFailOverPreference();

	/**
	 * Checks if the HA Module is Licensed
	 * @return
	 */
	Boolean isHighAvailabilityModuleLicensed();
	
}
