package com.tandbergtv.neptune.ui.realm.client.networkelements.view;

import com.google.gwt.core.client.GWT;
import com.tandbergtv.neptune.ui.framework.client.application.TimedEvent;
import com.tandbergtv.neptune.ui.framework.client.application.TimedEventHandler;
import com.tandbergtv.neptune.ui.realm.client.RealmUIEvents;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIService;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.INetworkElementsUIServiceAsync;
import com.tandbergtv.neptune.ui.realm.client.networkelements.service.UiNetworkElementStatus;
import com.tandbergtv.neptune.widgettoolkit.client.remote.NeptuneAsyncCallback;

/**
 * 		Class that stores the current Redundancy status on the UI.
 * 	
 * @author Francisco Bento da Silva Neto
 *
 */
public class RedundancyStatusStateHolder implements TimedEventHandler {

	/* The RPC service */
	private static final INetworkElementsUIServiceAsync service = GWT.create(INetworkElementsUIService.class);
	
	protected static UiNetworkElementStatus currentStatus = UiNetworkElementStatus.DISABLED;

	@Override
	public void onTimerElapsed(TimedEvent authenticationEvent) {
		refreshCurrentStatus(false);
	}

	/**
	 * 		Gets the latest fetched status from server.
	 * 
	 * @return
	 */
	public static UiNetworkElementStatus getCurrentStatus() {
		return currentStatus;
	}
	
	/**
	 * 		Refresh the server status notify all of its listeners if it has changed.
	 * 
	 * @param forceRefresh If set to TRUE will fire an event even if status haven't changed. 
	 * @return
	 */
	public static void refreshCurrentStatus(final boolean forceRefresh) {
		service.getRedundancyStatus(new NeptuneAsyncCallback<UiNetworkElementStatus>() {
			@Override
			public void onNeptuneFailure(Throwable caught) {
				// do nothing, keep last state
			}

			@Override
			public void onNeptuneSuccess(UiNetworkElementStatus result) {
				if (!result.equals(currentStatus) || forceRefresh) {
					currentStatus = result;
					RealmUIEvents.EVENT_BUS.fireEvent(new RedundancyStatusUpdateEvent(result));
				} 
			}

		});
	}
	
}
