/*
 * Created on May 21, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import java.util.Iterator;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.HasOpenHandlers;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.HasAnimation;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link DisclosurePanel} widget. Since the
 * DisclosurePanel is a final class, this widget wraps the panel in a composite.
 * 
 * @see com.google.gwt.user.client.ui.DisclosurePanel
 * @author Vijay Silva
 */
public class DisclosureContainer extends Composite implements HasOpenHandlers<DisclosureContainer>,
        HasCloseHandlers<DisclosureContainer>, HasWidgets, HasAnimation, INeptuneWidget {

	/* The panel */
	private DisclosurePanel panel;

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel()
	 */
	public DisclosureContainer() {
		this.panel = new DisclosurePanel();
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String)
	 */
	public DisclosureContainer(String headerText) {
		this.panel = new DisclosurePanel(headerText);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String, boolean)
	 */
	public DisclosureContainer(String headerText, boolean isOpen) {
		this.panel = new DisclosurePanel(headerText, isOpen);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget)
	 */
	public DisclosureContainer(Widget header) {
		this.panel = new DisclosurePanel(header);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget, boolean)
	 */
	public DisclosureContainer(Widget header, boolean isOpen) {
		this.panel = new DisclosurePanel(header, isOpen);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(DisclosurePanelImages,
	 *      String, boolean)
	 */
	public DisclosureContainer(DisclosurePanelImages images, String headerText, boolean isOpen) {
		this.panel = new DisclosurePanel(images, headerText, isOpen);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
		EventDelegator delegator = new EventDelegator();
		this.panel.addOpenHandler(delegator);
		this.panel.addCloseHandler(delegator);

		this.initWidget(panel);
	}

	// ========================================================================
	// ===================== EVENT HANDLING
	// ========================================================================

	@Override
	public HandlerRegistration addOpenHandler(OpenHandler<DisclosureContainer> handler) {
		return addHandler(handler, OpenEvent.getType());
	}

	@Override
	public HandlerRegistration addCloseHandler(CloseHandler<DisclosureContainer> handler) {
		return addHandler(handler, CloseEvent.getType());
	}

	// ========================================================================
	// ===================== HAS WIDGETS
	// ========================================================================

	@Override
	public void add(Widget w) {
		this.panel.add(w);
	}

	@Override
	public boolean remove(Widget w) {
		return this.panel.remove(w);
	}

	@Override
	public void clear() {
		this.panel.clear();
	}

	@Override
	public Iterator<Widget> iterator() {
		return this.panel.iterator();
	}

	// ========================================================================
	// ===================== HAS ANIMATION
	// ========================================================================

	@Override
	public boolean isAnimationEnabled() {
		return this.panel.isAnimationEnabled();
	}

	@Override
	public void setAnimationEnabled(boolean enable) {
		this.panel.setAnimationEnabled(enable);
	}

	// ========================================================================
	// ===================== DISCLOSURE PANEL METHODS
	// ========================================================================

	/**
	 * @see DisclosurePanel#getContent()
	 */
	public Widget getContent() {
		return this.panel.getContent();
	}

	/**
	 * @see DisclosurePanel#getHeader()
	 */
	public Widget getHeader() {
		return this.panel.getHeader();
	}

	/**
	 * @see DisclosurePanel#getHeaderTextAccessor()
	 */
	public HasText getHeaderTextAccessor() {
		return this.panel.getHeaderTextAccessor();
	}

	/**
	 * @see DisclosurePanel#isOpen()
	 */
	public boolean isOpen() {
		return this.panel.isOpen();
	}

	/**
	 * @see DisclosurePanel#setContent(Widget)
	 */
	public void setContent(Widget content) {
		this.panel.setContent(content);
	}

	/**
	 * @see DisclosurePanel#setHeader(Widget)
	 */
	public void setHeader(Widget headerWidget) {
		this.panel.setHeader(headerWidget);
	}

	/**
	 * @see DisclosurePanel#setOpen(boolean)
	 */
	public void setOpen(boolean isOpen) {
		this.panel.setOpen(isOpen);
	}

	/*
	 * Internal class that delegates the events fired by the contained panel
	 */
	private final class EventDelegator implements OpenHandler<DisclosurePanel>,
	        CloseHandler<DisclosurePanel> {

		@Override
		public void onOpen(OpenEvent<DisclosurePanel> event) {
			delegateEvent(DisclosureContainer.this, event);
		}

		@Override
		public void onClose(CloseEvent<DisclosurePanel> event) {
			delegateEvent(DisclosureContainer.this, event);
		}
	}
}
