/*
 * Created on May 21, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import org.cobogw.gwt.user.client.ui.RoundedPanel;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.DisclosurePanel;
import com.google.gwt.user.client.ui.DisclosurePanelImages;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.DisclosureContainer;

/**
 * A decorated version of the disclosure panel which will enable the header to have rounded corners. 
 * Extends DisclosureContainer which in turn extends the GWT {@link DisclosurePanel} widget. 
 * 
 * @see com.google.gwt.user.client.ui.DisclosurePanel
 * @author mpetrusis
 * 
 * <h3>CSS Style Rules</h3>
 * <ul class="css">
 * <li>wtk-RoundedDisclosureContainer { the panel's primary style }</li>
 * <li>wtk-RoundedDisclosureContainer-open { dependent style set when panel is open }</li>
 * <li>wtk-RoundedDisclosureContainer-closed { dependent style set when panel is closed }</li>
 * 
 * <p>
 * <img class='gallery' src='DisclosurePanel.png'/>
 * </p>
 * 
 * <p>
 * The header and content sections can be easily selected using css with a child
 * selector:<br/> .gwt-DisclosurePanel-open .header { ... }
 * </p>
 * 
 * <p>
 * The label and label-corner sections can be easily selected using css with a child
 * selector:<br/> .gwt-DisclosurePanel-open .label { ... } 
 * <br/> .gwt-DisclosurePanel-open .label-corners { ... }
 * </p>

 */
public class RoundedDisclosureContainer extends DisclosureContainer {


	
	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String)
	 */
	public RoundedDisclosureContainer(String headerText) {
		initialize (headerText);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(String, boolean)
	 */
	public RoundedDisclosureContainer(String headerText, boolean isOpen) {
		initialize (headerText);
		setOpen (isOpen);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget)
	 */
	public RoundedDisclosureContainer(Widget header) {
		super (header);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(Widget, boolean)
	 */
	public RoundedDisclosureContainer(Widget header, boolean isOpen) {
		super (header, isOpen);
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.DisclosurePanel#DisclosurePanel(DisclosurePanelImages,
	 *      String, boolean)
	 */
	public RoundedDisclosureContainer(DisclosurePanelImages images, String headerText, boolean isOpen) {
		super (images, headerText, isOpen);
		initialize (headerText);

	}
	
	private Widget initialize (String headerText) {

		setStyleName(STYLENAME_DEFAULT);
		
		RoundedPanel container = new RoundedPanel(RoundedPanel.ALL, 3);
		container.setCornerStyleName(STYLENAME_LABEL_CORNERS);
		
		DisclosurePanelImages images = GWT.create(RoundedDisclosurePanelImages.class);
		container.setWidget(new DefaultHeader(images, headerText));

		setHeader(container);

		return container;
	}

	  // Stylename constants.
	  private static final String STYLENAME_DEFAULT = "wtk-RoundedDisclosureContainer";
	
	  private static final String STYLENAME_LABEL = "label";

	  private static final String STYLENAME_LABEL_CORNERS = "label-corners";

	  /**
	   * The default header widget used within a {@link DisclosurePanel}.
	   */
	  private class DefaultHeader extends Widget implements HasText,
	      OpenHandler<DisclosureContainer>, CloseHandler<DisclosureContainer> {

	    /**
	     * imageTD holds the image for the icon, not null. labelTD holds the text
	     * for the label.
	     */
	    private final Element labelTD;

	    private final Image iconImage;
	    private final DisclosurePanelImages images;

	    private DefaultHeader(DisclosurePanelImages images, String text) {
	      this.images = images;

	      iconImage = isOpen() ? images.disclosurePanelOpen().createImage()
	          : images.disclosurePanelClosed().createImage();

	      // I do not need any Widgets here, just a DOM structure.
	      Element root = DOM.createTable();
	      Element tbody = DOM.createTBody();
	      Element tr = DOM.createTR();
	      final Element imageTD = DOM.createTD();
	      labelTD = DOM.createTD();
	      root.setAttribute("class", STYLENAME_LABEL);
	      root.setAttribute("width", "100%");

	      setElement(root);

	      DOM.appendChild(root, tbody);
	      DOM.appendChild(tbody, tr);
	      DOM.appendChild(tr, imageTD);
	      DOM.appendChild(tr, labelTD);

	      // set image TD to be same width as image.
	      DOM.setElementProperty(imageTD, "align", "center");
	      DOM.setElementProperty(imageTD, "valign", "middle");
	      DOM.setStyleAttribute(imageTD, "width", iconImage.getWidth() + "px");

	      DOM.appendChild(imageTD, iconImage.getElement());

	      setText(text);

	      addOpenHandler(this);
	      addCloseHandler(this);
	      setStyle();
	    }

	    public final String getText() {
	      return DOM.getInnerText(labelTD);
	    }

	    public final void onClose(CloseEvent<DisclosureContainer> event) {
	      setStyle();
	    }

	    public final void onOpen(OpenEvent<DisclosureContainer> event) {
	      setStyle();
	    }

	    public final void setText(String text) {
	      DOM.setInnerText(labelTD, text);
	    }

	    private void setStyle() {
	      if (isOpen()) {
	        images.disclosurePanelOpen().applyTo(iconImage);
	      } else {
	        images.disclosurePanelClosed().applyTo(iconImage);
	      }
	    }
	  }
	
	  
	
}
