package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.PageFeatureImages;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

public class PageFeatureHandler<K, R extends Record<K>> implements TableConstants, FeatureHandler {
	private final PageFeature pageFeature;

	public PageFeatureHandler(final DataProvider<K, R> dataProvider, final TableInternal<K, R> table,
			final PageFeature pageFeature) {
		this.pageFeature = pageFeature;

		HorizontalContainer paginationPanel = table.getPaginationPanel();
		paginationPanel.clear();
		paginationPanel.setWidth("100%");
		paginationPanel.setSpacing(15);
		paginationPanel.setHorizontalAlignment(HorizontalContainer.ALIGN_CENTER);
		paginationPanel.setVerticalAlignment(VerticalContainer.ALIGN_MIDDLE);
		final PageSizePanel pageSizePanel = new PageSizePanel(dataProvider, table, pageFeature);
		paginationPanel.add(pageSizePanel);
		paginationPanel.setCellHorizontalAlignment(pageSizePanel, HorizontalContainer.ALIGN_LEFT);
		final Widget pageCountPanel = new PageCountPanel(table, dataProvider);
		paginationPanel.add(pageCountPanel);
		paginationPanel.setCellHorizontalAlignment(pageCountPanel, HorizontalContainer.ALIGN_LEFT);
		final Widget gotoPagePanel = new GotoPagePanel(table, dataProvider, pageFeature);
		paginationPanel.add(gotoPagePanel);
		paginationPanel.setCellHorizontalAlignment(gotoPagePanel, HorizontalContainer.ALIGN_RIGHT);

		reload();
	}

	private final class GotoPagePanel extends HorizontalContainer {
		private final TextBoxWidget pageNumberWidget;

		public GotoPagePanel(final TableInternal<K, R> table, final DataProvider<K, R> dataProvider,
				final PageFeature pageFeature) {
			setVerticalAlignment(ALIGN_MIDDLE);

			LabelWidget gotoPageLabelWidget = new LabelWidget("go to page:");
			gotoPageLabelWidget.setStyleName(STYLE_GENERAL_TEXT);
			add(gotoPageLabelWidget);
			pageNumberWidget = new TextBoxWidget();
			pageNumberWidget.setMaxLength(5);
			pageNumberWidget.setVisibleLength(2);
			pageNumberWidget.addKeyPressHandler(new KeyPressHandler() {
				@Override
				public void onKeyPress(KeyPressEvent event) { // sender, char keyCode, int modifiers) {
					if (event.getCharCode() == KeyCodes.KEY_ENTER) {
						int pageNumber;
						try {
							pageNumber = Integer.parseInt(pageNumberWidget.getText());
						} catch(NumberFormatException e) {
							Window.alert("Please enter a valid page number");
							return;
						}
						
						if(pageNumber < 0) {
							Window.alert("Please enter a valid page number");
							return;
						}
						
						//find total pages
						int totalPages = pageFeature.getTotalSize() / pageFeature.getLength();
						if(pageFeature.getTotalSize() % pageFeature.getLength() > 0)
							totalPages++;
						
						//if the entered page number is later than last page, goto last page
						//fix for bug #3836
						if(pageNumber > totalPages) {
							pageNumber = totalPages;
							pageNumberWidget.setText(String.valueOf(pageNumber));
						}
						
						pageFeature.setStart((pageNumber - 1) * pageFeature.getLength());
						table.refresh();
					}
				}
			});
			add(pageNumberWidget);
		}
	}

	private final class PageCountPanel extends HorizontalContainer {
		private final PageFeatureImages imageBundle;
		private final ImageWidget leftLeftWidget;
		private final ImageWidget leftWidget;
		private final LabelWidget pageCountWidget;
		private final ImageWidget rightWidget;
		private final ImageWidget rightRightWidget;

		public PageCountPanel(final TableInternal<K, R> table, final DataProvider<K, R> dataProvider) {
			this.imageBundle = GWT.create(PageFeatureImages.class);

			setVerticalAlignment(ALIGN_MIDDLE);
			setSpacing(NAV_SPACING);
			
			leftLeftWidget = new ImageWidget();
			leftLeftWidget.setStyleName(STYLE_NAV_BUTTON);
			add(leftLeftWidget);
			leftWidget = new ImageWidget();
			leftWidget.setStyleName(STYLE_NAV_BUTTON);
			add(leftWidget);
			pageCountWidget = new LabelWidget("");
			pageCountWidget.setStyleName(STYLE_GENERAL_TEXT);
			add(pageCountWidget);
			rightWidget = new ImageWidget();
			rightWidget.setStyleName(STYLE_NAV_BUTTON);
			add(rightWidget);
			rightRightWidget = new ImageWidget();
			rightRightWidget.setStyleName(STYLE_NAV_BUTTON);
			add(rightRightWidget);

			table.addListener(new TableInternal.Listener<K, R>() {
				public void recordsUpdated() {
					int recordTotal = pageFeature.getTotalSize();
					int recordsPerPage = pageFeature.getLength();
					int totalPages = recordTotal / recordsPerPage;
					if (recordTotal % recordsPerPage > 0)
						totalPages++;

					int currentPage = pageFeature.getStart() / recordsPerPage + 1;

					pageCountWidget.setText("page " + currentPage + " of " + totalPages);

					AbstractImagePrototype prototype = null; 
					boolean isLeftEnabled = currentPage != 1;
					prototype = isLeftEnabled ? imageBundle.firstPageEnabled() : imageBundle.firstPageDisabled();
					prototype.applyTo(leftLeftWidget);
					prototype = isLeftEnabled ? imageBundle.previousPageEnabled() : imageBundle.previousPageDisabled();
					prototype.applyTo(leftWidget);

					boolean isRightEnabled = currentPage != totalPages;
					prototype = isRightEnabled ? imageBundle.lastPageEnabled() : imageBundle.lastPageDisabled();
					prototype.applyTo(rightRightWidget);
					prototype = isLeftEnabled ? imageBundle.nextPageEnabled() : imageBundle.nextPageDisabled();
					prototype.applyTo(rightWidget);
				}
			});

			leftLeftWidget.addClickHandler(new ClickHandler() {
						public void onClick(ClickEvent event) {
							pageFeature.setStart(0);
							table.refresh();
						}
					});
			leftWidget.addClickHandler(new ClickHandler() {
						public void onClick(ClickEvent event) {
							int newStart = pageFeature.getStart() - pageFeature.getLength();
							pageFeature.setStart(newStart >= 0 ? newStart : 0);
							table.refresh();
						}
					});
			rightWidget.addClickHandler(new ClickHandler() {
						public void onClick(ClickEvent event) {
							int nextStart = pageFeature.getStart() + pageFeature.getLength();
							if(nextStart < pageFeature.getTotalSize()) {
								pageFeature.setStart(nextStart);
								table.refresh();
							}
						}
					});
			rightRightWidget.addClickHandler(new ClickHandler() {
						public void onClick(ClickEvent event) {
							int toMinus = pageFeature.getTotalSize() % pageFeature.getLength();
							if (toMinus == 0)
								toMinus = pageFeature.getLength();
							int newStart = pageFeature.getTotalSize() - toMinus;
							pageFeature.setStart(newStart >= 0 ? newStart : 0);
							table.refresh();
						}
					});
		}
	}

	private final class PageSizePanel extends HorizontalContainer {
		private final PageFeature pageFeature;
		private Grid grid;

		public PageSizePanel(final DataProvider<K, R> dataProvider, final TableInternal<K, R> simpleTable,
				final PageFeature pageFeature) {
			this.pageFeature = pageFeature;
			
			setVerticalAlignment(ALIGN_MIDDLE);
			
			//add buttons
			final int pageSizeCount = pageFeature.getPageSizes().length;
			grid = new Grid(1, pageSizeCount);
			grid.setStyleName(STYLE_PAGE_SIZE_TABLE);

			for (int i = 0; i < pageSizeCount; ++i)
				grid.setWidget(0, i, new LabelWidget(String.valueOf(pageFeature.getPageSizes()[i])));
			
			grid.addClickHandler(new ClickHandler() {
				public void onClick(ClickEvent event) {
					int clickedCellIndex = grid.getCellForEvent(event).getCellIndex();
					pageFeature.setLength(pageFeature.getPageSizes()[clickedCellIndex]);
					simpleTable.refresh();
					updateSizeStatus();
				}});

			updateSizeStatus();
			add(grid);
			
			setSpacing(PAGESIZE_TEXT_SPACING);
			
			//add text
			LabelWidget suffixLabel = new LabelWidget("rows per page");
			suffixLabel.setStyleName(STYLE_GENERAL_TEXT);
			add(suffixLabel);
		}

		public void updateSizeStatus() {
			int i = 0;
			for (int pageSize : pageFeature.getPageSizes()) {
					grid.getCellFormatter().setStyleName(0, i++,
											(pageSize == pageFeature.getLength())
												? STYLE_CURRENT_PAGE_SIZE_CELL
												: STYLE_PAGE_SIZE_CELL);
			}
		}

	}

	public void reload() {
		pageFeature.setStart(0);
		if (pageFeature.getPageSizes().length > 0)
			pageFeature.setLength(pageFeature.getPageSizes()[0]);
	}

	public void init() {
	}

}
