package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import java.util.List;

import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

/**
 * This interface provides all the methods necessary to add features to the
 * table. This interface exposes internal state of the table and is only meant
 * to be used by table features.
 * 
 * TODO refactor the relationship between the table and features to improve
 * encapsulation.
 * 
 * @param <R>
 *            record type being used
 */
public interface TableInternal<K, R extends Record<K>> {
	void setRootWidget(Widget widget);

	void setListView();

	void updateView(R record);

	List<Column<?, R>> listVisibleColumns();

	List<Widget> listWidgetsForVisibleColumn(Column<?, R> column);

	R getRecordForWidget(Widget widget);

	void addListener(Listener<K, R> listener);

	void refresh();

	HorizontalPanel getHeaderColPanelForColumn(Column<?, R> column);

	Label getHeaderLabelForColumn(Column<?, R> column);

	HorizontalContainer getPaginationPanel();

	void registerWidgetOnActionContainer(Widget widget);

	void addColumn(Column<?, R> column);
	
	void showCreatePage();

	void showRecord(R record);

	public interface Listener<K, R extends Record<K>> {
		void recordsUpdated();
	}

	List<R> getSelectedRecords();
	
	void revertToInitialState();
}
