package com.tandbergtv.neptune.widgettoolkit.client.application;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.component.Component;

/**
 * Provides singleton access to the main Neptune class.
 * 
 * @author trybak
 */
public abstract class NeptuneApplication {

	/* The Neptune application */
	protected static NeptuneApplication INSTANCE;

	/**
	 * Get the Neptune Application
	 * 
	 * @return The Neptune Application
	 */
	public static NeptuneApplication getApplication() {
		return INSTANCE;
	}

	/**
	 * Get the widget that contains the Neptune application
	 * 
	 * @return The main container widget that contains the application.
	 */
	public abstract Widget getMainContainer();

	/**
	 * Gets the service loader.
	 */
	public abstract ServiceLoader getServiceLoader();

	/**
	 * Performs error handling for any errors resulting from asynchronous calls made to the server.
	 * If the exception is not handled by the component, the application will catch and handle this
	 * error.
	 * 
	 * @param caught The error resulting from a server request
	 * @return true if the error is handled, false otherwise
	 */
	public abstract boolean handleThrowable(Throwable caught);

	/**
	 * Get the component instance given the component class. The class must exactly match the class
	 * of the component instance.
	 * 
	 * @param <T> The type of the component
	 * @param componentClass The class for the component
	 * @return The component with matching class, or null if no component matches the class.
	 */
	public abstract <T extends Component> T getComponent(Class<T> componentClass);
}
