package com.tandbergtv.neptune.widgettoolkit.client.component;

import java.util.List;
import java.util.Map;

import com.tandbergtv.neptune.widgettoolkit.client.application.PortletFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.Service;
import com.tandbergtv.neptune.widgettoolkit.client.application.ServiceLoader;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventListenerRegistry;
import com.tandbergtv.neptune.widgettoolkit.client.event.EventSink;
import com.tandbergtv.neptune.widgettoolkit.client.menu.GroupMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.menu.MenuItemBase;
import com.tandbergtv.neptune.widgettoolkit.client.menu.WidgetMenuItem;
import com.tandbergtv.neptune.widgettoolkit.client.security.NeptuneSecurity;

/**
 * A Component is the main entry point into Neptune. All implementations of this interface can be
 * added to the list of Components provided to {@link NeptuneApplicationImpl}. This list of
 * components will then be queried for portlets, tabs, services, etc.
 * 
 * @author trybak
 */
public interface Component {

	/**
	 * Initialize the component
	 * 
	 * @param eventListenerRegistry The event listener registry
	 * @param eventSink The event sink
	 * @param serviceLoader The service loader
	 */
	void init(EventListenerRegistry eventListenerRegistry, EventSink eventSink,
	        ServiceLoader serviceLoader, Map<String, String> info);

	/**
	 * List all portlets defined in this component, each exposed as {@link WidgetMenuItem}.
	 * 
	 * @param security {@link NeptuneSecurity} of currently logged in user.
	 * @return list of {@link WidgetMenuItem} instances.
	 */
	List<PortletFactory> listPortlets(NeptuneSecurity security);

	/**
	 * List all tabs defined in this component, exposed as a forest where the trees are
	 * {@link GroupMenuItem} instances and leaves are {@link WidgetMenuItem} instances.
	 * 
	 * @param security {@link NeptuneSecurity} of currently logged in user.
	 * @return forest with each tree being a {@link GroupMenuItem} instance and each leaf being a
	 *         {@link WidgetMenuItem} instance.
	 */
	List<MenuItemBase> listTabs(NeptuneSecurity security);

	/**
	 * List of all {@link Service} instances exposed by this component.
	 * 
	 * @param clazz class of services that will be returned.
	 * @param security {@link NeptuneSecurity} of currently logged in user.
	 * @return list of services that implement the specific interface.
	 */
	<E extends Service> List<E> listServices(Class<E> clazz, NeptuneSecurity security);

}
