package com.tandbergtv.neptune.widgettoolkit.client.menu;

import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.application.SingletonWidgetFactory;
import com.tandbergtv.neptune.widgettoolkit.client.application.WidgetFactory;

public class WidgetMenuItem extends MenuItemBase {
	protected final WidgetFactory widgetFactory;
	protected final AnchorChangeListener listener;
	private final AnchorChangeListener reverseListener;
	private AnchorChangeListener frameworkListener;

	public WidgetMenuItem(String name, WidgetFactory widgetFactory) {
		this(name, widgetFactory, new NoopAnchorChangeListener());
	}

	public WidgetMenuItem(String name, Widget widget, AnchorChangeListener listener) {
		this(name, new SingletonWidgetFactory(widget), listener);
	}

	public WidgetMenuItem(String name, Widget widget) {
		this(name, widget, new NoopAnchorChangeListener());
	}

	public WidgetMenuItem(String name, WidgetFactory widgetFactory, AnchorChangeListener listener) {
		super(name);
		this.widgetFactory = widgetFactory;
		this.listener = listener;
		reverseListener = new AnchorChangeListener() {
			public void anchorChanged(String anchor) {
				if (frameworkListener != null)
					frameworkListener.anchorChanged(anchor);
			}
		};
	}

	public void setAnchor(String anchor) {
		if (reverseListener != null) {
			reverseListener.anchorChanged(anchor);
		}
	}

	public void setReverseAnchorChangeListener(AnchorChangeListener frameworkListener) {
		this.frameworkListener = frameworkListener;
	}

	public WidgetFactory getWidgetFactory() {
		return widgetFactory;
	}

	public AnchorChangeListener getReverseAnchorChangeListener() {
		return reverseListener;
	}

	public AnchorChangeListener getAnchorChangeListener() {
		return listener;
	}

	private final static class NoopAnchorChangeListener implements AnchorChangeListener {
		public void anchorChanged(String url) {
		}
	}

	public interface AnchorChangeListener {
		void anchorChanged(String anchor);
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

}
