package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class FormContainer extends Composite implements INeptuneWidget {
	private static final String STYLE_CONTAINER_TABLE = "form-container-table";
	private static final String STYLE_LABEL_CELL = "form-label-cell";
	private static final String STYLE_VALUE_CELL = "form-value-cell";
	private static final String STYLE_REQUIRED = "form-required";
	private static final String STYLE_LABEL = "form-label";
	private static final String STYLE_VALUE = "form-value";
	private static final int MAINPANEL_SPACING = 10;

	private VerticalPanel mainPanel;
	private FlexTable formTable;
	private HorizontalPanel buttonPanel;

	public FormContainer(HasHorizontalAlignment.HorizontalAlignmentConstant buttonPanelHAlign) {
		mainPanel = new VerticalPanel();
		mainPanel.setSpacing(MAINPANEL_SPACING);
		formTable = new FlexTable();
		formTable.setStyleName(STYLE_CONTAINER_TABLE);
		buttonPanel = new HorizontalPanel();

		mainPanel.add(formTable);
		mainPanel.setCellHorizontalAlignment(formTable, VerticalPanel.ALIGN_CENTER);

		mainPanel.add(buttonPanel);
		mainPanel.setCellHorizontalAlignment(buttonPanel, buttonPanelHAlign);

		initWidget(mainPanel);
	}

	public int addRow(LabelWidget label, Widget value, boolean markRequired) {
		// TODO should add to and not override the widget style
		label.setStyleName(STYLE_LABEL);
		value.setStyleName(STYLE_VALUE);
		int lastRowIndex = formTable.getRowCount();
		if(markRequired) {
			HorizontalContainer container = new HorizontalContainer();
			container.setStyleName(STYLE_LABEL);
			LabelWidget requiredMarker = new LabelWidget("*");
			requiredMarker.setStyleName(STYLE_REQUIRED);
			container.add(requiredMarker);
			container.setCellWidth(requiredMarker, "10");
			container.add(label);
			formTable.setWidget(lastRowIndex, 0, container);
		} else {
			formTable.setWidget(lastRowIndex, 0, label);
		}
		formTable.getCellFormatter().setStyleName(lastRowIndex, 0, STYLE_LABEL_CELL);
		
		formTable.setWidget(lastRowIndex, 1, value);
		formTable.getCellFormatter().setStyleName(lastRowIndex, 1, STYLE_VALUE_CELL);
		
		return lastRowIndex;
	}

	public int addRow(LabelWidget label, Widget value) {
		return addRow(label, value, false);
	}
	
	public int addRow(String first, Widget second, boolean markRequired) {
		return addRow(new LabelWidget(first), second, markRequired);
	}

	public int addRow(String first, Widget second) {
		return addRow(first, second, false);
	}

	public void removeRow(int index) {
		formTable.removeRow(index);
	}

	public void addButton(ButtonWidget buttonWidget) {
		buttonPanel.add(buttonWidget);
	}

	public void removeButton(ButtonWidget buttonWidget) {
		buttonPanel.remove(buttonWidget);
	}
}
