package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.style.StyleNames;

/**
 * this panel should be used by pages that want to show a header.
 * @author vaibhav
 *
 */
public class HeaderPanel extends VerticalContainer implements INeptuneWidget {
	LabelWidget label;
	
	public HeaderPanel(String label) {
		super();
		this.label = new LabelWidget(label);
		this.label.setStyleName(StyleNames.HEADER_LABEL);
		this.setVerticalAlignment(ALIGN_MIDDLE);
		this.add(this.label);
		this.setStyleName(StyleNames.HEADER);
	}

	public void setLabel(String label) {
		this.label.setText(label);
	}
}
