package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.TableInternal;

/**
 * Manages the paging variables
 */
public final class PageFeatureImpl<K, R extends Record<K>> implements PageFeature {

	public PageFeatureImpl(final TableInternal<K, R> tableInternal) {
		tableInternal.addListener(new TableInternal.Listener<K, R>() {
			public void recordsUpdated() {
				informListener();
			}
		});
	}

	private int start;
	private int length = 10;
	private int totalSize;
	private Listener listener;

	public int getLength() {
		return length;
	}

	public void setTotalSize(int totalSize) {
		this.totalSize = totalSize;
	}

	public int[] getPageSizes() {
		return new int[] { 10, 25, 50, 100 };
	}

	public int getStart() {
		return start;
	}

	public int getTotalSize() {
		return totalSize;
	}

	public void setLength(int length) {
		this.length = length;
		informListener();
	}

	public void setStart(int start) {
		this.start = start;
		informListener();
	}

	private void informListener() {
		if (listener != null)
			listener.pagingUpdated(getStart(), getLength());
	}

	public void registerListener(Listener listener) {
		this.listener = listener;
	}

}