/**
 * 
 */
package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

public final class SortFeatureImpl<K, R extends Record<K>> implements SortFeature<K, R> {
	private final Column<?, R> defaultSortColumn;
	private final SortOrder defaultSortOrder;
	private Column<?, R> sortColumn;
	private SortOrder sortOrder;
	private final List<Column<?, R>> sortableColumns;

	public SortFeatureImpl(Column<?, R> defaultSortColumn, SortOrder defaultSortOrder) {
		this.defaultSortColumn = defaultSortColumn;
		this.defaultSortOrder = defaultSortOrder;
		setSortColumn(defaultSortColumn);
		setSortOrder(defaultSortOrder);
		sortableColumns = new ArrayList<Column<?, R>>();
	}

	public Column<?, R> getDefaultSortColumn() {
		return defaultSortColumn;
	}

	public SortOrder getDefaultSortOrder() {
		return defaultSortOrder;
	}

	public Column<?, R> getSortColumn() {
		return sortColumn;
	}

	public SortOrder getSortOrder() {
		return sortOrder;
	}

	public boolean isColumnSortable(Column<?, R> column) {
		return sortableColumns.contains(column);
	}

	public void addSortableColumn(Column<?, R> column) {
		sortableColumns.add(column);
	}

	public void setSortColumn(Column<?, R> columnColumn) {
		this.sortColumn = columnColumn;
	}

	public void setSortOrder(SortOrder sortOrder) {
		this.sortOrder = sortOrder;
	}

	public boolean isAscending() {
		return getSortOrder().equals(SortOrder.ASCENDING);
	}

	public String getSortColumnName() {
		return getSortColumn().getName();
	}
}