package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Widget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ButtonWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.ColumnCommandsFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.ColumnCommandsFeature.ColumnCommand;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.View;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.view.ViewBase;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.HorizontalContainer;

public class ColumnCommandsFeatureHandler<K, R extends Record<K>> implements FeatureHandler {
	public ColumnCommandsFeatureHandler(final ColumnCommandsFeature<R> feature, final TableInternal<K, R> tableInternal) {
		tableInternal.addColumn(new Column<R, R>() {
			public String getDisplayName() {
				return "Actions";
			}

			public String getName() {
				return "actions";
			}

			public View<R> getView(final R record) {
				return new ViewBase<R>(record) {
					protected R getViewValue() {
						return record;
					}

					protected void preInitialValueSet() {
					}

					protected void setViewValue(R value) {
					}

					@Override
					public Widget getWidget() {
						HorizontalContainer buttonBar = new HorizontalContainer();
						for (final ColumnCommand command : feature.getCommands(record))
							buttonBar.add(new ButtonWidget(command.getCommandText(), new ClickHandler() {
								public void onClick(ClickEvent event) {
									command.execute();
								}
							}));
						return buttonBar;
					}

					public void release() {
					}
				};
			}
		});
	}

	public void reload() {
	}
	
	public void init() {
	}

}
