package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Label;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.DataProvider;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.TableConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.SortFeature;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.impl.images.SortFeatureImages;

public class SortFeatureHandler<K, R extends Record<K>> implements TableConstants, FeatureHandler {
	private final TableInternal<K, R> simpleTable;
	private final SortFeature<K, R> sortFeature;
	private final SortFeatureImages bundle;
	private final ImageWidget sortImage;

	public SortFeatureHandler(DataProvider<K, R> dataProvider, TableInternal<K, R> simpleTable,
			SortFeature<K, R> sortFeature) {
		this.simpleTable = simpleTable;
		this.sortFeature = sortFeature;
		this.bundle = GWT.create(SortFeatureImages.class);
		this.sortImage = new ImageWidget();
		reload();
	}

	public void init() {
		/* Set the default sort column and order */
		updateSortColumn(sortFeature.getDefaultSortColumn(), sortFeature.getDefaultSortOrder());

		/* For each sortable column, add a click listener to change the sort column / order */
		for (final Column<?, R> column : simpleTable.listVisibleColumns()) {
			if (sortFeature.isColumnSortable(column)) {
				final Label headerLabel = simpleTable.getHeaderLabelForColumn(column);
				headerLabel.setStyleName(STYLE_HEADER_SORTABLE_COL_TEXT);
				headerLabel.addClickHandler(new ClickHandler() {
					public void onClick(ClickEvent event) {
						SortOrder order = sortFeature.getDefaultSortOrder();
						if (sortFeature.getSortColumn().equals(column)) {
							SortOrder oldOrder = sortFeature.getSortOrder();
							order = (oldOrder != SortOrder.ASCENDING) ? SortOrder.ASCENDING
							        : SortOrder.DESCENDING;
						}
						
						updateSortColumn(column, order);
						simpleTable.refresh();
					}
				});
			}
		}
	}

	public void reload() {
		updateSortColumn(sortFeature.getDefaultSortColumn(), sortFeature.getDefaultSortOrder());
	}

	private void updateSortColumn(Column<?, R> column, SortOrder sortOrder) {
		sortFeature.setSortColumn(column);
		sortFeature.setSortOrder(sortOrder);
		
		/* There is only one sort image shown, remove it from current location and update it */
		sortImage.removeFromParent();
		updateSortImage(sortOrder);

		/* Add the image to the correct column */
		if (column != null && sortOrder != null)
			simpleTable.getHeaderColPanelForColumn(column).add(sortImage);
	}
	
	private void updateSortImage(SortOrder sortOrder) {
		boolean ascending = (sortOrder == SortOrder.ASCENDING);
		AbstractImagePrototype prototype = ascending ? bundle.ascending() : bundle.descending();
		prototype.applyTo(sortImage);
	}
}
