package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;

import java.util.List;

import com.google.gwt.user.client.rpc.AsyncCallback;

/**
 * Provides the basic functionality of displaying a table view.
 *
 * @param <R> Record type
 * @param <K> Key type
 */
public interface DataProvider<K, R extends Record<K>> {
	/**
	 * Initialize any necessary internal state. Most common use is to obtain any
	 * necessary information from the server.
	 * 
	 * @param callback
	 */
	void initialize(AsyncCallback<Void> callback);

	/**
	 * Provide the columns for the table.
	 * 
	 * @return columns
	 */
	List<Column<?, R>> getColumns();

	/**
	 * Return the records for this table. The choice as to which records should
	 * be returned, i.e. paging, is beyond the scope of this interface.
	 * 
	 * @param callback async interface for the return of records. 
	 */
	void getRecords(AsyncCallback<List<R>> callback);

	/**
	 * Returns the record with matching key
	 * 
	 * @param key The record key
	 * @param callback The callback providing notification of the matching record found
	 */
	void getRecord(K key, AsyncCallback<R> callback);
	
	/**
	 * If true, then a record count is diplayed below the records.
	 * @return should a count be displayed
	 */
	boolean isRecordCountEnabled();

	/**
	 * 
	 * @return
	 */
	boolean isCheckboxEnabled();
}
