/*
 * Created on Oct 20, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.server.locale;

import java.util.Locale;

/**
 * Service that provides the locale to use when receiving requests from the client
 * 
 * @author Vijay Silva
 */
public final class ClientLocaleProvider implements IClientLocaleProvider {

	private static final ClientLocaleProvider instance = new ClientLocaleProvider();
	private ThreadLocal<Locale> locale = new ThreadLocal<Locale>();

	/* Cannot instantiate */
	private ClientLocaleProvider() {
	}

	/**
	 * Get the client locale provider
	 * 
	 * @return The client locale provider
	 */
	public static IClientLocaleProvider getClientLocaleProvider() {
		return instance;
	}

	/**
	 * Get the locale used by the client
	 * 
	 * @return the client locale
	 */
	@Override
	public Locale getLocale() {
		return instance.locale.get();
	}

	/**
	 * Set the client locale for the current request.
	 */
	public static void setLocale(Locale locale) {
		instance.locale.set(locale);
	}
}
