package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table;


public abstract class ColumnBase<A, R extends Record<?>> implements Column<A, R> {
	private final String name;
	private final String displayName;
	private String style;

	public ColumnBase(String name, String displayName) {
		this.name = name;
		this.displayName = displayName;
		this.style = TableConstants.STYLE_DATACELL_TEXT;
	}

	public String getName() {
		return name;
	}

	public String getDisplayName() {
		return displayName;
	}

	@Override
	public String getCellStyle() {
	    return style;
	}
	
	/**
	 * Set the style to apply for all column cells in the table
	 * 
	 * @param style the style name
	 */
	public void setCellStyle(String style) {
		this.style = style;
	}
}
