package com.tandbergtv.neptune.widgettoolkit.client.menu;

public class ActionMenuItem extends MenuItemBase {
	private final Runnable runnable;

	public ActionMenuItem(String name, Runnable runnable) {
		super(name);
		this.runnable = runnable;
	}
	
	public ActionMenuItem(String name, String displayName, Runnable runnable) {
		super(name, displayName);
		this.runnable = runnable;
	}

	@Override
	public void accept(Visitor visitor) {
		visitor.visit(this);
	}

	public Runnable getRunnable() {
		return runnable;
	}

}
