package com.tandbergtv.neptune.widgettoolkit.client.remote;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneApplication;
import com.tandbergtv.neptune.widgettoolkit.client.application.NeptuneException;

/**
 * Base class for all {@link AsyncCallback} implementations that are used in Neptune remoting. This
 * base class takes care of processing all thrown {@link NeptuneException} instances that are
 * specific to the Neptune runtime. All other thrown exceptions are passed along. This class has to
 * be used in every single GWT RPC call to the Neptune server.
 * 
 * @author trybak
 */
public abstract class NeptuneAsyncCallback<T> implements AsyncCallback<T> {

	public final void onFailure(Throwable caught) {
		NeptuneApplication app = NeptuneApplication.getApplication();
		if (!app.handleThrowable(caught))
			onNeptuneFailure(caught);
	}

	public final void onSuccess(T result) {
		onNeptuneSuccess(result);
	}

	public abstract void onNeptuneFailure(Throwable caught);

	public abstract void onNeptuneSuccess(T result);
}
