/*
 * Created on May 17, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.basic;

import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.ui.Hidden;
import com.google.gwt.user.client.ui.RootPanel;
import com.tandbergtv.neptune.widgettoolkit.client.widget.INeptuneWidget;

/**
 * The toolkit widget extension for the GWT {@link Hidden} widget.
 * 
 * @see com.google.gwt.user.client.ui.Hidden
 * @author Vijay Silva
 */
public class HiddenWidget extends Hidden implements INeptuneWidget {

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hidden#Hidden()
	 */
	public HiddenWidget() {
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hidden#Hidden(String)
	 */
	public HiddenWidget(String name) {
		super(name);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hidden#Hidden(String, String)
	 */
	public HiddenWidget(String name, String value) {
		super(name, value);
		initializeWidget();
	}

	/**
	 * Constructor
	 * 
	 * @see com.google.gwt.user.client.ui.Hidden#Hidden(Element)
	 */
	protected HiddenWidget(Element element) {
		super(element);
		initializeWidget();
	}

	/*
	 * Perform any initialization of the widget at the end of construction.
	 */
	private void initializeWidget() {
	}

	/**
	 * Builds a widget wrapping the input element
	 * 
	 * @see com.google.gwt.user.client.ui.Hidden#wrap(Element)
	 */
	public static HiddenWidget wrap(Element element) {
		assert Document.get().getBody().isOrHasChild(element);
		HiddenWidget widget = new HiddenWidget(element);
		widget.onAttach();
		RootPanel.detachOnWindowClose(widget);
		return widget;
	}
}
