/*
 * Created on Aug 18, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.PopupPanel.PositionCallback;
import com.tandbergtv.neptune.widgettoolkit.client.widget.WidgetConstants;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.ImageWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.LabelWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.PopupContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.SimpleContainer;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * A widget that works as a pop up and indicates to the user that the client is busy
 * 
 * @author Vijay Silva
 */
public class BusyIndicator extends Composite {

	private final SimpleContainer popupWrapper;
	private final PopupPanel glass;
	private final PopupPanel popup;
	private ImageWidget busyImage;
	private LabelWidget busyLabel;
	private WidgetConstants constants;

	/* Style Names */
	private static final String STYLE_NAME = "nwt-BusyIndicator";
	private static final String GLASS_STYLE_NAME = "nwt-BusyIndicator-Glass";
	private static final String IMAGE_STYLE_NAME = "image";
	private static final String LABEL_STYLE_NAME = "text";
	private static final String IMAGE_URL = "neptune_widget_toolkit/images/busy-indicator.gif";

	/**
	 * Creates an modal popup container that displays the progress.
	 */
	public BusyIndicator() {
		this(true);
	}

	/**
	 * Creates an popup container that displays the progress.
	 * 
	 * @param modal flag indicating that this popup container should be modal
	 */
	public BusyIndicator(boolean modal) {
		constants = GWT.create(WidgetConstants.class);

		this.glass = new PopupContainer(false, true);
		this.glass.setStyleName(GLASS_STYLE_NAME);

		this.popupWrapper = new SimpleContainer();
		this.popup = new PopupContainer(false, modal);
		initialize();
		this.initWidget(popupWrapper);
	}

	/*
	 * Initialize the contents of this widget
	 */
	private void initialize() {
		/* Use the new style name */
		popup.setStylePrimaryName(STYLE_NAME);

		/* Build the contents of the popup */
		VerticalContainer contents = new VerticalContainer();
		contents.setHorizontalAlignment(HasHorizontalAlignment.ALIGN_CENTER);
		contents.setSpacing(3);
		popup.setWidget(contents);

		/* Build the image to show */
		busyImage = new ImageWidget();
		busyImage.setStylePrimaryName(IMAGE_STYLE_NAME);
		busyImage.setUrl(IMAGE_URL);
		contents.add(busyImage);

		/* Add text below the image */
		busyLabel = new LabelWidget();
		busyLabel.setStylePrimaryName(LABEL_STYLE_NAME);
		contents.add(busyLabel);
		busyLabel.setText(constants.busyIndicatorMessage());
	}

	/**
	 * Hide or show the busy message. If hidden, only the image will show
	 * 
	 * @param visible true to show, false to hide the busy message
	 */
	public void setBusyMessageVisible(boolean visible) {
		busyLabel.setVisible(visible);
	}

	/**
	 * Set the busy message to use when showing the busy indicator
	 * 
	 * @param message The message to use
	 */
	public void setBusyMessage(String message) {
		busyLabel.setText(message);
	}

	/**
	 * Override the default image with the new image specified by the URL
	 * 
	 * @param imageURL The new image URL
	 */
	public void setBusyImage(String imageURL) {
		busyImage.setUrl(imageURL);
	}

	/**
	 * Center the popup on the browser window and show the popup. If the widget is already showing,
	 * center the widget on the browser window.
	 * 
	 * @see PopupContainer#center()
	 */
	public void center() {
		showGlassPopup();
		popup.center();
	}

	/**
	 * Set the width of the popup
	 * 
	 * @see PopupContainer#show()
	 */
	public void show() {
		showGlassPopup();
		popup.show();
	}

	/**
	 * Hide the popup. Has no effect if not already visible.
	 * 
	 * @see PopupContainer#hide()
	 */
	public void hide() {
		glass.hide();
		popup.hide();
	}

	/**
	 * Determine if the popup is showing
	 * 
	 * @see PopupContainer#isShowing()
	 */
	public boolean isShowing() {
		return popup.isShowing();
	}

	/**
	 * Determine if the popup is visible
	 * 
	 * @see PopupContainer#isVisible()
	 */
	@Override
	public boolean isVisible() {
		return popup.isVisible();
	}

	/**
	 * Set the popup to be visible or not
	 * 
	 * @see PopupContainer#setVisible(boolean)
	 */
	@Override
	public void setVisible(boolean visible) {
		popup.setVisible(visible);
	}

	/**
	 * Determine if the popup is modal
	 * 
	 * @see PopupContainer#isModal()
	 */
	public boolean isModal() {
		return popup.isModal();
	}

	/**
	 * Set the modal flag for the popup
	 * 
	 * @see PopupContainer#setModal(boolean)
	 */
	public void setModal(boolean modal) {
		popup.setModal(modal);
	}

	/**
	 * Set the title for the popup
	 * 
	 * @see PopupContainer#getTitle()
	 */
	@Override
	public String getTitle() {
		return popup.getTitle();
	}

	/**
	 * Set the title for the popup
	 * 
	 * @see PopupContainer#setTitle(String)
	 */
	@Override
	public void setTitle(String title) {
		popup.setTitle(title);
	}

	/**
	 * Set the height if the popup
	 * 
	 * @see PopupContainer#setHeight(String)
	 */
	@Override
	public void setHeight(String height) {
		popup.setHeight(height);
	}

	/**
	 * Set the width of the popup
	 * 
	 * @see PopupContainer#setWidth(String)
	 */
	@Override
	public void setWidth(String width) {
		popup.setWidth(width);
	}

	/**
	 * Set the position of the popup
	 * 
	 * @see PopupContainer#setPopupPosition(int, int)
	 */
	public void setPopupPosition(int left, int top) {
		popup.setPopupPosition(left, top);
	}

	/**
	 * Set the position of the popup and show the popup
	 * 
	 * @see PopupContainer#setPopupPositionAndShow(PositionCallback)
	 */
	public void setPopupPositionAndShow(PositionCallback callback) {
		showGlassPopup();
		popup.setPopupPositionAndShow(callback);
	}

	/**
	 * Show the popup relative to another widget
	 * 
	 * @see PopupContainer#showRelativeTo(UIObject)
	 */
	public void showRelativeTo(UIObject target) {
		showGlassPopup();
		popup.showRelativeTo(target);
	}

	private void showGlassPopup() {
		if (popup.isModal())
			glass.show();
	}
}
