/*
 * Created on May 27, 2009
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.datatype;

import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.BlurHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.event.dom.client.HasKeyDownHandlers;
import com.google.gwt.event.dom.client.HasKeyPressHandlers;
import com.google.gwt.event.dom.client.HasKeyUpHandlers;
import com.google.gwt.event.dom.client.HasMouseDownHandlers;
import com.google.gwt.event.dom.client.HasMouseMoveHandlers;
import com.google.gwt.event.dom.client.HasMouseOutHandlers;
import com.google.gwt.event.dom.client.HasMouseOverHandlers;
import com.google.gwt.event.dom.client.HasMouseUpHandlers;
import com.google.gwt.event.dom.client.HasMouseWheelHandlers;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.dom.client.KeyPressEvent;
import com.google.gwt.event.dom.client.KeyPressHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.dom.client.MouseWheelEvent;
import com.google.gwt.event.dom.client.MouseWheelHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.HasDirection;
import com.google.gwt.user.client.ui.HasName;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.TextBoxBase.TextAlignConstant;
import com.tandbergtv.neptune.widgettoolkit.client.widget.basic.TextBoxWidget;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.IValueConverter;
import com.tandbergtv.neptune.widgettoolkit.client.widget.datatype.converter.ValueFormatException;

/**
 * A Text Box Widget that ensures type safety for the value it displays. This widget adds an
 * additional style for data type error styling: dataTypeError
 * 
 * @author Vijay Silva
 */
public class TypedTextBoxWidget<DataType> extends DataTypeWidget<DataType> implements HasName,
        HasDirection, HasText, HasClickHandlers, HasKeyPressHandlers, HasKeyUpHandlers,
        HasKeyDownHandlers, HasMouseDownHandlers, HasMouseMoveHandlers, HasMouseOutHandlers,
        HasMouseOverHandlers, HasMouseUpHandlers, HasMouseWheelHandlers {

	/* The widget displaying the value */
	private TextBoxWidget widget;
	private IValueConverter<DataType> valueConverter;

	/**
	 * Constructs a new text box widget that maintains a typed value
	 * 
	 * @param valueConverter
	 */
	public TypedTextBoxWidget(IValueConverter<DataType> valueConverter) {
		super();

		this.valueConverter = valueConverter;
		this.widget = new TextBoxWidget();
		EventHandler eventHandler = new EventHandler();
		this.widget.addValueChangeHandler(eventHandler);

		/* The Text Box is the parent widget */
		super.initWidget(widget);
	}

	// ========================================================================
	// ===================== HAS NAME
	// ========================================================================

	/**
	 * @see TextBoxWidget#getName()
	 */
	@Override
	public String getName() {
		return widget.getName();
	}

	/**
	 * @see TextBoxWidget#setName(String)
	 */
	@Override
	public void setName(String name) {
		widget.setName(name);
	}

	// ========================================================================
	// ===================== HAS DIRECTION
	// ========================================================================

	/**
	 * @see TextBoxWidget#getDirection()
	 */
	@Override
	public Direction getDirection() {
		return widget.getDirection();
	}

	/**
	 * @see TextBoxWidget#setDirection(Direction)
	 */
	@Override
	public void setDirection(Direction direction) {
		widget.setDirection(direction);
	}

	// ========================================================================
	// ===================== HAS TEXT
	// ========================================================================

	/**
	 * @see TextBoxWidget#getText()
	 */
	@Override
	public String getText() {
		return widget.getText();
	}

	/**
	 * @see TextBoxWidget#setText(String)
	 */
	@Override
	public void setText(String text) {
		widget.setText(text);
	}

	// ========================================================================
	// ===================== EVENT HANDLERS
	// ========================================================================

	@Override
	public HandlerRegistration addClickHandler(ClickHandler handler) {
		return addDomHandler(handler, ClickEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyPressHandler(KeyPressHandler handler) {
		return addDomHandler(handler, KeyPressEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyUpHandler(KeyUpHandler handler) {
		return addDomHandler(handler, KeyUpEvent.getType());
	}

	@Override
	public HandlerRegistration addKeyDownHandler(KeyDownHandler handler) {
		return addDomHandler(handler, KeyDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseDownHandler(MouseDownHandler handler) {
		return addDomHandler(handler, MouseDownEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseMoveHandler(MouseMoveHandler handler) {
		return addDomHandler(handler, MouseMoveEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOutHandler(MouseOutHandler handler) {
		return addDomHandler(handler, MouseOutEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseOverHandler(MouseOverHandler handler) {
		return addDomHandler(handler, MouseOverEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseUpHandler(MouseUpHandler handler) {
		return addDomHandler(handler, MouseUpEvent.getType());
	}

	@Override
	public HandlerRegistration addMouseWheelHandler(MouseWheelHandler handler) {
		return addDomHandler(handler, MouseWheelEvent.getType());
	}

	// ========================================================================
	// ===================== HAS VALUE
	// ========================================================================

	/**
	 * Gets the typed value, or null if there was an error parsing the value
	 */
	@Override
	public DataType getValue() {
		DataType value = null;

		try {
			value = valueConverter.getTypedValue(widget.getText());
		} catch (ValueFormatException vfe) {
		}

		return value;
	}

	@Override
	public void setValue(DataType value) {
		this.setValue(value, false);
	}

	@Override
	public void setValue(DataType value, boolean fireEvents) {
		widget.setValue(valueConverter.getStringValue(value), fireEvents);
		this.updateWidgetState();
	}

	@Override
	public HandlerRegistration addValueChangeHandler(ValueChangeHandler<DataType> handler) {
		return this.addHandler(handler, ValueChangeEvent.getType());
	}

	// ========================================================================
	// ===================== FOCUSABLE
	// ========================================================================

	/**
	 * @see TextBoxWidget#getTabIndex()
	 */
	@Override
	public int getTabIndex() {
		return widget.getTabIndex();
	}

	/**
	 * @see TextBoxWidget#setTabIndex(int)
	 */
	@Override
	public void setTabIndex(int index) {
		widget.setTabIndex(index);
	}

	/**
	 * @see TextBoxWidget#setAccessKey(char)
	 */
	@Override
	public void setAccessKey(char key) {
		widget.setAccessKey(key);
	}

	/**
	 * @see TextBoxWidget#setFocus(boolean)
	 */
	@Override
	public void setFocus(boolean focused) {
		widget.setFocus(focused);
	}

	// ========================================================================
	// ===================== HAS ALL FOCUS HANDLERS
	// ========================================================================

	@Override
	public HandlerRegistration addFocusHandler(FocusHandler handler) {
		return this.addDomHandler(handler, FocusEvent.getType());
	}

	@Override
	public HandlerRegistration addBlurHandler(BlurHandler handler) {
		return this.addDomHandler(handler, BlurEvent.getType());
	}

	// ========================================================================
	// ===================== DATA TYPE WIDGET ABSTRACT METHODS
	// ========================================================================

	@Override
	public boolean isValidValue() {
		boolean valid = false;
		try {
			valueConverter.getTypedValue(widget.getText());
			valid = true;
		} catch (ValueFormatException vfe) {
		}

		return valid;
	}

	@Override
	public String getTextValue() {
		return this.getText();
	}

	@Override
	public void setTextValue(String textValue) {
		widget.setText(textValue);
		this.updateWidgetState();
	}

	/**
	 * @see TextBoxWidget#isReadOnly()
	 */
	@Override
	public boolean isReadOnly() {
		return widget.isReadOnly();
	}

	/**
	 * @see TextBoxWidget#setReadOnly(boolean)
	 */
	@Override
	public void setReadOnly(boolean readOnly) {
		widget.setReadOnly(readOnly);
	}

	/**
	 * @see TextBoxWidget#isEnabled()
	 */
	@Override
	public boolean isEnabled() {
		return widget.isEnabled();
	}

	/**
	 * @see TextBoxWidget#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		widget.setEnabled(enabled);
	}

	/**
	 * Add or remove the error style based on the error state
	 */
	protected void updateStyle() {
		if (this.isInErrorState())
			widget.addStyleDependentName(ERROR_STYLE);
		else
			widget.removeStyleDependentName(ERROR_STYLE);
	}

	@Override
	public String getCurrentToolTip() {
		return widget.getTitle();
	}

	@Override
	protected void setCurrentToolTip(String toolTip) {
		widget.setTitle(toolTip);
	}

	// ========================================================================
	// ===================== TEXT BOX DELEGATE METHODS
	// ========================================================================

	/**
	 * @see TextBoxWidget#getMaxLength()
	 */
	public int getMaxLength() {
		return widget.getMaxLength();
	}

	/**
	 * @see TextBoxWidget#setMaxLength(int)
	 */
	public void setMaxLength(int length) {
		widget.setMaxLength(length);
	}

	/**
	 * @see TextBoxWidget#getVisibleLength()
	 */
	public int getVisibleLength() {
		return widget.getVisibleLength();
	}

	/**
	 * @see TextBoxWidget#setVisibleLength(int)
	 */
	public void setVisibleLength(int length) {
		widget.setVisibleLength(length);
	}

	/**
	 * @see TextBoxWidget#cancelKey()
	 */
	public void cancelKey() {
		widget.cancelKey();
	}

	/**
	 * @see TextBoxWidget#getCursorPos()
	 */
	public int getCursorPos() {
		return widget.getCursorPos();
	}

	/**
	 * @see TextBoxWidget#setCursorPos(int)
	 */
	public void setCursorPos(int pos) {
		widget.setCursorPos(pos);
	}

	/**
	 * @see TextBoxWidget#getSelectedText()
	 */
	public String getSelectedText() {
		return widget.getSelectedText();
	}

	/**
	 * @see TextBoxWidget#getSelectionLength()
	 */
	public int getSelectionLength() {
		return widget.getSelectionLength();
	}

	/**
	 * @see TextBoxWidget#setSelectionRange(int, int)
	 */
	public void setSelectionRange(int pos, int length) {
		widget.setSelectionRange(pos, length);
	}

	/**
	 * @see TextBoxWidget#selectAll()
	 */
	public void selectAll() {
		widget.selectAll();
	}

	/**
	 * @see TextBoxWidget#setTextAlignment(TextAlignConstant)
	 */
	public void setTextAlignment(TextAlignConstant align) {
		widget.setTextAlignment(align);
	}

	// ========================================================================
	// ===================== EVENT DELEGATOR
	// ========================================================================

	/*
	 * Inner class that delegates the value change events to this class
	 */
	private class EventHandler implements ValueChangeHandler<String> {

		@Override
		public void onValueChange(ValueChangeEvent<String> event) {
			updateWidgetState();
			DataType value = null;

			try {
				/* Try getting the converted value */
				value = valueConverter.getTypedValue(event.getValue());
				String formattedValue = valueConverter.getStringValue(value);
				widget.setValue(formattedValue);
			} catch (ValueFormatException vfe) {
			}

			ValueChangeEvent.fire(TypedTextBoxWidget.this, value);
		}
	}
}
