package com.tandbergtv.neptune.widgettoolkit.client.menu;

public abstract class MenuItemBase {
	protected final String name;
	protected final String displayName;

	protected MenuItemBase(String name) {
		this.name = name;
		this.displayName = name;
	}

	protected MenuItemBase(String name, String displayName) {
		this.name = name;
		this.displayName = displayName;
	}

	public String getName() {
		return name;
	}

	/**
	 * @return the displayName
	 */
	public String getDisplayName() {
		return displayName;
	}

	public abstract void accept(Visitor visitor);

	public interface Visitor {
		void visit(GroupMenuItem panelContainer);

		void visit(WidgetMenuItem panel);

		void visit(ActionMenuItem action);
		
		void visit(MenuItemProxy proxy);
	}
}
