package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import java.util.Date;

import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.datepicker.client.CalendarUtil;

/**
 * Stores page size of the table in a cookie in addition to memory.
 * 
 * @author rprakash
 */
public class CookieStoreBasedPageFeatureImpl extends PageFeatureImpl {
	private String pageSizeCookieName;
	private Date expiryDate;
	
	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix) {
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addMonthsToDate(expiryDate, 1200);	//adding 100 years
	}
	
	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, boolean showTotalCount) {
		super(showTotalCount);
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addMonthsToDate(expiryDate, 1200);	//adding 100 years
	}
	
	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, int daysToExpire) {
		setCookieNamePrefix(cookieNamePrefix);
		expiryDate = new Date();
		CalendarUtil.addDaysToDate(expiryDate, daysToExpire);
	}
	
	public CookieStoreBasedPageFeatureImpl(String cookieNamePrefix, Date expiryDate) {
		setCookieNamePrefix(cookieNamePrefix);
		this.expiryDate = expiryDate;
	}
	
	private void setCookieNamePrefix(String cookieNamePrefix) {
		pageSizeCookieName = cookieNamePrefix + "_pageSize";
	}
	
	@Override
	public int getPageSize() {
		try {
			return Integer.parseInt(Cookies.getCookie(pageSizeCookieName));
		} catch(Exception e) {
			return super.getPageSize();
		}
	}

	@Override
	public void setPageSize(int size) {
		if (size <= 0)
			size = getDefaultPageSize();

		super.setPageSize(size);
		Cookies.setCookie(pageSizeCookieName, String.valueOf(size), expiryDate);
	}

}
