package com.tandbergtv.neptune.widgettoolkit.client.widget.composite;

/*
 * When making multiple async calls, this busy indicator will continue to be rendered until all calls return back. 
 * 
 */
public class MultiTaskBusyIndicator {
	private BusyIndicator busyIndicator = new BusyIndicator();
	private int count = 0;

	public synchronized void center() {
		if (count++ == 0)
			busyIndicator.center();
	}

	public synchronized void hide() {
		if (--count == 0)
			busyIndicator.hide();
	}

	public synchronized void hideAll() {
		count = 0;
		busyIndicator.hide();
	}
}
