package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature;

import java.util.Set;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Column;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.Record;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.SortOrder;

public interface SortFeature<K, R extends Record<K>> extends Feature {

	/**
	 * Determine if the table column can be sorted
	 * 
	 * @param column The table column
	 * @return true if the column can be sorted, false otherwise
	 */
	boolean isColumnSortable(Column<?, R> column);

	/**
	 * Get the collection of columns that are sort enabled
	 * 
	 * @return The sort enabled columns
	 */
	Set<Column<?, R>> getSortableColumns();

	/**
	 * Get the default sort order
	 * 
	 * @return The default sort order
	 */
	SortOrder getDefaultSortOrder();

	/**
	 * Get the default sort column
	 * 
	 * @return The default sort column
	 */
	Column<?, R> getDefaultSortColumn();

	/**
	 * Get the sort order
	 * 
	 * @return The sort order
	 */
	SortOrder getSortOrder();

	/**
	 * Set the sort order to use with the sort column
	 * 
	 * @param sortOrder The sort order
	 */
	void setSortOrder(SortOrder sortOrder);

	/**
	 * Get the table column to sort
	 * 
	 * @return The sort column
	 */
	Column<?, R> getSortColumn();

	/**
	 * Set the column to sort
	 * 
	 * @param column The column to sort
	 */
	void setSortColumn(Column<?, R> column);
}
