package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.impl;

import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;

/**
 * Manages the paging variables
 */
public class PageFeatureImpl implements PageFeature {

	/* Properties */
	private int pageNumber;
	private int pageSize;
	private int recordCount;
	private int defaultPageSize;
	private int[] pageSizes = new int[] { 10, 25, 50, 100 };
	private boolean showTotalCount = true;
	private boolean hasMorePages;

	/**
	 * Constructor
	 */
	public PageFeatureImpl() {
		setDefaultPageSize(pageSizes[0]);
		reset();
	}
	
	/**
	 * Constructor
	 */
	public PageFeatureImpl(boolean showTotalCount) {
		setDefaultPageSize(pageSizes[0]);
		this.showTotalCount = showTotalCount;
		reset();
	}
	
	/**
	 * Constructor
	 * 
	 * @param defaultPageSize the default page size
	 */
	public PageFeatureImpl(int defaultPageSize) {
		setDefaultPageSize(defaultPageSize);
		reset();
	}

	@Override
	public int getPageNumber() {
		return pageNumber;
	}

	@Override
	public void setPageNumber(int pageNumber) {
		if (pageNumber <= 0)
			pageNumber = 1;

		this.pageNumber = pageNumber;
	}

	@Override
	public int getPageSize() {
		return pageSize;
	}

	@Override
	public void setPageSize(int size) {
		if (size <= 0)
			size = getDefaultPageSize();

		this.pageSize = size;
	}

	@Override
	public int getRecordCount() {
		return recordCount;
	}

	@Override
	public void setRecordCount(int recordCount) {
		this.recordCount = recordCount;
	}

	@Override
	public int[] getPageSizes() {
		return pageSizes;
	}

	/**
	 * Get the default page size used when reseting the feature
	 * 
	 * @return The default page size
	 */
	@Override
	public int getDefaultPageSize() {
		return defaultPageSize;
	}

	/*
	 * Set the default page size
	 */
	private void setDefaultPageSize(int defaultPageSize) {
		if (defaultPageSize <= 0)
			defaultPageSize = pageSizes[0];

		this.defaultPageSize = defaultPageSize;
	}

	@Override
	public void reset() {
		this.pageNumber = 1;
		this.pageSize = defaultPageSize;
		this.recordCount = -1;
	}

	@Override
	public boolean hasMorePages() {
		return hasMorePages;
	}
	
	@Override
	public void setHasMorePages(boolean hasMorePages) {
		this.hasMorePages = hasMorePages;
	}
	
	@Override
	public boolean showTotalCount() {
		return showTotalCount;
	}

	@Override
	public void setShowTotalCount(boolean showTotalCount) {
		this.showTotalCount = showTotalCount;
	}

}
