/*
 * Created on Jun 29, 2009
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.container;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.HandlerRegistration;
import com.gwtext.client.core.Function;
import com.gwtext.client.widgets.Tool;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentAttachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.DocumentDetachHandler;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasDocumentAttachHandlers;
import com.tandbergtv.neptune.widgettoolkit.client.widget.event.HasDocumentDetachHandlers;

/**
 * The toolkit portlet widget that is displayed in the 'Home' page of the application.
 * 
 * @author Raj Prakash
 * @author Vijay Silva
 * @author Daniel Paranhos
 */
@SuppressWarnings("unchecked")
public class Portlet extends com.gwtext.client.widgets.portal.Portlet implements
        HasDocumentAttachHandlers, HasDocumentDetachHandlers, HasCloseHandlers<Portlet> {

	private String id;
	private String displayName;

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet()
	 */
	public Portlet(String id) {
		super();
		this.id = id;
		this.displayName = "";
		addCloseTool();
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param displayName the portlet display name
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet()
	 */
	public Portlet(String id, String displayName) {
		super();
		this.id = id;
		this.displayName = displayName;
		addCloseTool();
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param title the portlet title
	 * @param html the html content
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet(String, String)
	 */
	public Portlet(String id, String title, String html) {
		super(title, html);
		this.id = id;
		this.displayName = title;
		addCloseTool();
	}

	/**
	 * Constructor
	 * 
	 * @param id the portlet id
	 * @param title the portlet title
	 * @param html the html content
	 * @param tools the toolbar tools
	 * @see com.gwtext.client.widgets.portal.Portlet#Portlet(String, String, Tool[])
	 */
	public Portlet(String id, String title, String html, Tool[] tools) {
		super(title, html, tools);
		this.id = id;
		this.displayName = title;
		addCloseTool();
	}

	private void addCloseTool() {
		addTool(new Tool(Tool.CLOSE, new Function() {
			@Override
			public void execute() {
				CloseEvent.fire(Portlet.this, Portlet.this);
			}
		}));
	}

	/**
	 * Gets the portlet id
	 * 
	 * @return the portlet id
	 */
	public String getPortletId() {
		return id;
	}

	/**
	 * Gets the portlet display name
	 * 
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Gets the portlet display name
	 * 
	 * @param displayName the display name
	 */
	public void setDisplayName(String displayName) {
		this.displayName = displayName;
	}

	// ========================================================================
	// ===================== EVENT REGISTRATION
	// ========================================================================

	@Override
	public HandlerRegistration addDocumentAttachHandler(DocumentAttachHandler handler) {
		return addHandler(handler, DocumentAttachEvent.getType());
	}

	@Override
	public HandlerRegistration addDocumentDetachHandler(DocumentDetachHandler handler) {
		return addHandler(handler, DocumentDetachEvent.getType());
	}

	@Override
	public HandlerRegistration addCloseHandler(CloseHandler<Portlet> handler) {
		return addHandler(handler, CloseEvent.getType());
	}
}
