package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.messagearea;

import com.google.gwt.user.client.ui.Composite;
import com.tandbergtv.neptune.widgettoolkit.client.widget.container.VerticalContainer;

/**
 * @author esunpur
 *
 */
public class MessageArea extends Composite {

	private static final String MESSAGE_AREA_STYLE = "nwt-MessageArea"; 

	protected VerticalContainer mainContainer;
	protected ErrorPanel errorPanel;
	protected MessagePanel infoPanel;

	public MessageArea() {
		mainContainer = new VerticalContainer();
		mainContainer.addStyleName(MESSAGE_AREA_STYLE);
		errorPanel = new ErrorPanel();
		infoPanel = new MessagePanel();
		mainContainer.add(infoPanel);
		mainContainer.add(errorPanel);
		
		initWidget(mainContainer);
	}
	
	public void setErrorMessage(String message) {
		if ((message != null) && !message.trim().equals("")) {
			infoPanel.setVisible(false);
			errorPanel.setVisible(true);
			errorPanel.setText(message);
		}
		else {
			errorPanel.setVisible(false);
		}
	}

	public void setErrorHTML(String html) {
		if ((html != null) && !html.trim().isEmpty()) {
			infoPanel.setVisible(false);
			errorPanel.setVisible(true);
			errorPanel.setHTML(html);
		}
		else {
			errorPanel.setVisible(false);
		}
	}
	
	public void setInfoMessage(String message) {
		if ((message != null) && !message.trim().isEmpty()) {
			errorPanel.setVisible(false);
			infoPanel.setVisible(true);
			infoPanel.setText(message);
		}
		else {
			infoPanel.setVisible(false);
		}
	}

	public void setWidth(String width) {
		errorPanel.setWidth(width);
		infoPanel.setWidth(width);
	}
	
	public void reset() {
		errorPanel.setVisible(false);
		infoPanel.setVisible(false);
	}
}
