/*
 * Created on Sep 15, 2010
 * 
 * (C) Copyright TANDBERG Television Inc.
 */

package com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.event;

import com.google.gwt.event.shared.GwtEvent;
import com.tandbergtv.neptune.widgettoolkit.client.widget.composite.table.feature.PageFeature;

/**
 * Event indicating that the user has attempted to navigate to a new page
 * 
 * @author Vijay Silva
 */
public class PageNavigationEvent extends GwtEvent<PageNavigationHandler> {

	/* The Handler type */
	private static Type<PageNavigationHandler> TYPE;

	private final int newPageNumber;
	private final PageFeature pageFeature;

	/**
	 * Constructor
	 * 
	 * @param newPageNumber The new page number
	 * @param feature The page feature that contains the current paging information
	 */
	public PageNavigationEvent(int newPageNumber, PageFeature feature) {
		this.newPageNumber = newPageNumber;
		this.pageFeature = feature;
	}

	/**
	 * Gets the type associated with this event.
	 * 
	 * @return returns the handler type
	 */
	public static Type<PageNavigationHandler> getType() {
		if (TYPE == null) {
			TYPE = new Type<PageNavigationHandler>();
		}

		return TYPE;
	}

	@Override
	public Type<PageNavigationHandler> getAssociatedType() {
		return TYPE;
	}

	@Override
	protected void dispatch(PageNavigationHandler handler) {
		handler.onPageNavigation(this);
	}

	/**
	 * Get the new page number
	 * 
	 * @return The new page number
	 */
	public int getNewPageNumber() {
		return this.newPageNumber;
	}

	/**
	 * Get the page feature
	 * 
	 * @return The page feature
	 */
	public PageFeature getPageFeature() {
		return pageFeature;
	}
}
