package com.tandbergtv.neptune.widgettoolkit.client.menu;

/**
 * The base menu item structure that the components construct when providing the list of menu items
 * that must be displayed by the neptune framework.
 * 
 * @author trybak
 * @author Vijay Silva
 */
public abstract class MenuItemBase {

	/* Properties */
	protected final String name;
	protected final String displayName;

	/**
	 * Constructor - creates a new menu item with the given name. The name is also used as the
	 * display name.
	 * 
	 * @param name The name (also used as the display name)
	 */
	protected MenuItemBase(String name) {
		this(name, name);
	}

	/**
	 * Constructor - creates a new menu item with the given name and display name.
	 * 
	 * @param name The name
	 * @param displayName The display name
	 */
	protected MenuItemBase(String name, String displayName) {
		this.name = name;
		this.displayName = displayName;
	}

	/**
	 * Get the name of the menu item, which is used in the application history anchors
	 * 
	 * @return The name
	 */
	public String getName() {
		return name;
	}

	/**
	 * Get the display name for the menu item shown in the application UI
	 * 
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * Support for the visitor pattern
	 * 
	 * @param visitor The visitor
	 */
	public abstract void accept(Visitor visitor);

	/**
	 * The visitor interface to support for the visitor pattern for this class hierarchy
	 */
	public interface Visitor {

		/**
		 * Visit the GroupMenuItem implementation
		 * 
		 * @param panelContainer The GroupMenuItem object to visit
		 */
		void visit(GroupMenuItem panelContainer);

		/**
		 * Visit the WidgetMenuItem implementation
		 * 
		 * @param panel The WidgetMenuItem object to visit
		 */
		void visit(WidgetMenuItem panel);

		/**
		 * Visit the ActionMenuItem implementation
		 * 
		 * @param action The ActionMenuItem object to visit
		 */
		void visit(ActionMenuItem action);

		/**
		 * Visit the MenuItemProxy implementation
		 * 
		 * @param proxy The MenuItemProxy object to visit
		 */
		void visit(MenuItemProxy proxy);
	}
}
